<?php

namespace App\Services;

use App\Classes\MikrotikService\SyncWithMk;
use App\Http\Controllers\SessionRefreshController;
use App\Models\Client;
use Carbon\Carbon;
use Exception;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;

class ExpirationService
{
    public function syncExpiration($userId)
    {
        $client = Client::where('userid',$userId)->first();

        $check_expire = (new SyncWithMk())->isDisable($client);

        if($check_expire){
            DB::table('radcheck')
                ->updateOrInsert(
                    [
                        'username' => $userId,
                        'attribute' => 'Expiration',
                        'op' => ':=',
                        'value' => "23 Sep 2004 12:00"
                    ]
            );

            if(isset($client->ip_address)  && filter_var($client->ip_address, FILTER_VALIDATE_IP)){

                DB::table('radreply')->where('username',$userId)->delete();
            }

            try{
                SessionRefreshController::userDisconnectProcess($userId);
            }catch(Exception $e){

            }

        }else{

            DB::table('radcheck')
            ->where('username',$userId)
            ->where('attribute','Expiration')->delete();

            if(isset($client->ip_address) && filter_var($client->ip_address, FILTER_VALIDATE_IP)){
                DB::table('radreply')
                    ->updateOrInsert(
                        [
                            'username' => $userId,
                            'attribute' => 'Framed-IP-Address',
                            'op' => ':=',
                            'value' => $client->ip_address
                        ]
                    );

                DB::table('radreply')
                ->updateOrInsert(
                    [
                        'username' => $userId,
                        'attribute' => 'Service-Type',
                        'op' => ':=',
                        'value' => "Framed-User"
                    ]
                );
            }





        }


        DB::table('radcheck')
        ->where('username', $userId)
        ->update([
            'op' => ':=',
        ]);

    }

    public function setExpireTimeClients($userNameList){

        foreach($userNameList as $userId){
            DB::table('radcheck')
            ->updateOrInsert(
                [
                    'username' => $userId,
                    'attribute' => 'Expiration',
                    'op' => ':=',
                    'value' => "23 Sep 2004 12:00"
                ]
            );

            $client = Client::where('userid',$userId)->first();

            if(isset($client->ip_address) && filter_var($client->ip_address, FILTER_VALIDATE_IP)){
                DB::table('radreply')->where('username',$userId)->delete();
            }
        }

        DB::table('radcheck')
        ->whereIn('username', $userNameList)
        ->update([
            'op' => ':=',
        ]);



    }

    public function handleExpiration($userId,$old_expire_date,$old_payment_dead_line,$pop_expire_check)
    {
        $previousExpireDate = Carbon::parse($old_expire_date)->addDay($old_payment_dead_line)->endOfDay();
        $checkIsClientOnExpirePoolOrNot = $pop_expire_check == "No" && $previousExpireDate->lessThan(Carbon::now());
        $this->syncExpiration($userId);
        if($checkIsClientOnExpirePoolOrNot){
            try{
                SessionRefreshController::userDisconnectProcess($userId);
            }catch(Exception $e){

            }
        }
    }
}
