@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title">
                <i class="fas fa-calendar-clock mr-1"></i>
                Reminder Voice SMS Schedule Settings
            </h3>
        </div>
        <div class="card-body">
            <form action="{{ route('voice-reminder-schedule.store') }}" method="POST" id="reminderScheduleForm">
                @csrf

                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="days_before" class="form-label">
                                Days Before Expire Date <span class="text-danger">*</span>
                            </label>
                            <input type="number"
                                   class="form-control @error('days_before') is-invalid @enderror"
                                   id="days_before"
                                   name="days_before"
                                   value="{{ old('days_before', $daysBefore) }}"
                                   min="1"
                                   max="60"
                                   required>
                            @error('days_before')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                Number of days before the expire date to send reminder voice SMS to due customers. (Range: 1-60 days)
                            </small>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="schedule_time" class="form-label">
                                Schedule Time <span class="text-danger">*</span>
                            </label>
                            <input type="time"
                                   class="form-control @error('schedule_time') is-invalid @enderror"
                                   id="schedule_time"
                                   name="schedule_time"
                                   value="{{ old('schedule_time', $scheduleTime) }}"
                                   step="60"
                                   required>
                            @error('schedule_time')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                Set the time when reminder voice SMS should be sent. Format: 24-hour format (HH:MM), e.g., 14:30 for 2:30 PM, 09:00 for 9:00 AM
                            </small>
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="voice_id" class="form-label">
                                Voice File <span class="text-muted">(Optional)</span>
                            </label>
                            <select class="form-control @error('voice_id') is-invalid @enderror"
                                    id="voice_id"
                                    name="voice_id">
                                <option value="">Use Latest Enabled Voice (Default)</option>
                                @foreach($enabledVoices as $voice)
                                    <option value="{{ $voice->id }}" {{ old('voice_id', $voiceId) == $voice->id ? 'selected' : '' }}>
                                        {{ $voice->title ?? $voice->original_name }} (ID: {{ $voice->id }})
                                    </option>
                                @endforeach
                            </select>
                            @error('voice_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                            <small class="form-text text-muted">
                                Select a specific voice file from the library. If not selected, the latest enabled voice will be used.
                            </small>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save mr-1"></i>
                                Save Schedule
                            </button>
                            <a href="{{ route('sendVoice') }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-left mr-1"></i>
                                Back to Send Voice
                            </a>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card mt-3">
        <div class="card-header">
            <h3 class="card-title">
                <i class="fas fa-info-circle mr-1"></i>
                Information
            </h3>
        </div>
        <div class="card-body">
            <div class="alert alert-info">
                <h5><i class="fas fa-lightbulb mr-2"></i>About Reminder Voice SMS Schedule</h5>
                <ul class="mb-0">
                    {{-- <li>This setting controls when the <code>php artisan voice:send-reminder</code> command will automatically run.</li> --}}
                    <li><strong>Days Before Expire Date:</strong> The command will target due customers who will expire in the specified number of days.</li>
                    <li>For example, if you set "3 days", the command will send reminders to customers who have due amounts and will expire in exactly 3 days.</li>
                    <li><strong>Schedule Time:</strong> The time when the command will run daily. Uses 24-hour format (00:00 to 23:59). Example: 14:30 = 2:30 PM, 09:00 = 9:00 AM.</li>
                    <li><strong>Voice File:</strong> Select a specific voice file from your library. If not selected, the latest enabled voice will be used automatically.</li>
                    <li>The command runs <strong>daily</strong> at the specified time and checks for customers expiring in the specified number of days.</li>
                    {{-- <li><strong>Note:</strong> Make sure your cron job is properly configured to run Laravel's scheduler (<code>php artisan schedule:run</code>) every minute.</li> --}}
                </ul>
            </div>
        </div>
    </div>
@endsection

@section('ajax')
<script>
    $(document).ready(function() {
        // Form validation
        $('#reminderScheduleForm').on('submit', function(e) {
            var timeValue = $('#schedule_time').val();
            var daysBefore = $('#days_before').val();

            if (!timeValue) {
                e.preventDefault();
                alert('Please select a time for reminder voice SMS schedule.');
                return false;
            }

            if (!daysBefore || daysBefore < 1 || daysBefore > 60) {
                e.preventDefault();
                alert('Days before expire date must be between 1 and 60.');
                return false;
            }

            // Validate time format (24-hour format HH:MM)
            var timePattern = /^([01][0-9]|2[0-3]):[0-5][0-9]$/;
            if (!timePattern.test(timeValue)) {
                e.preventDefault();
                alert('Invalid time format. Please use 24-hour format (HH:MM), e.g., 14:30 for 2:30 PM, 09:00 for 9:00 AM.');
                return false;
            }
        });
    });
</script>
@endsection
