@extends('layout.app')
@section('content')


    <form action="{{ route('tokenCode.update', $tokenCode->id) }}" method="POST" name="editForm">
        @method('PUT')
        @csrf
        <div class="card">
            <div class="card-body">
                <div class="row">
                <div class="form-group col-md-4">
                    <label for="shortname">
                        Token Category*
                    </label>
                    <select class="form-control bSelect" name="tokenCategory">
                        <option value="">Select Token Category</option>
                        @forelse ($tokenCategory as $item)
                            <option value="{{ $item->id }}">{{ $item->tokenCategory }}</option>
                        @empty
                        @endforelse
                    </select>
                </div>
                
                <div class="form-group col-md-4">
                    <label for="shortname">
                        Token Code*
                    </label>
                  
                        <input type="text" name="tokenCode" id="name" value="{{ $tokenCode->tokenCode }}"
                            class="form-control " placeholder="Token Category" autocomplete="off">
                  
                    @error('tokenCode')<div class="alert alert-danger mt-1">{{ $message }}</div>@enderror
                </div>
            </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary float-right">
                        Update
                    </button>
                </div>

            </div>
        </div>
    </form>


    <script>
        document.forms['editForm'].elements['tokenCategory'].value = '{{ $tokenCode->tokenCategory }}'
    </script>

@endsection
