@extends('layout.app')
@section('content')


    <form action="{{ route('assignStore', $token->id) }}" method="POST" name="editForm">
        {{-- @method('PUT') --}}
        @csrf
        <div class="card">
            <div class="card-body">
                <input type="hidden" name="assignUserId" value="{{ Auth::user()->id }}">
                <div class="form-group col-md-6">
                    <label for="shortname">
                        Assign Token*
                    </label>

                    <select class="form-control bSelect" name="assignToken">
                        <option value="">Select Employee</option>
                        @forelse ($employees as $item)
                            <option value="{{ $item->id }}">{{ $item->name }} - {{ $item->user_id }}</option>
                        @empty
                        @endforelse
                    </select>
                </div>

                
                <div class="form-group col-md-8">
                    <button type="submit" class="btn btn-primary float-right">
                        Assign
                    </button>
                </div>

            </div>
        </div>
    </form>


    <script>
        //    document.forms['editForm'].elements['tokenCategory'].value='{{ $token->tokenCategory }}'
        document.forms['editForm'].elements['assignToken'].value = '{{ $token->assignToken }}'
    </script>

@endsection
