@extends('layout.app')

@section('content')
    <h4>Parsed FreeRADIUS Log Information</h4>

    <div class="container-fluid bg-white my-3 py-2 shadow-sm">
        <table id="logsTable" class="display">
            <thead>
                <tr>
                    <th>Timestamp</th>
                    <th>Tried Username</th>
                    <th>MAC Address</th>
                    <th>NAS Name</th>
                    <th>Original Log Line</th>
                </tr>
            </thead>
            <tbody>
                @php use Carbon\Carbon; @endphp
                @foreach ($logs as $index => $log)
                    @php
                        $formattedTime = Carbon::createFromFormat('D M d H:i:s Y', $log['timestamp'])->format(
                            'Y-m-d h:i:s A',
                        );
                    @endphp
                    <tr>
                        <td>{{ $formattedTime }}</td>
                        <td>"{{ $log['username'] }}"</td>
                        <td>{{ $log['mac_address'] }}</td>
                        <td>{{ $log['nas_name'] }}</td>
                        <td>{{ $log['original_line'] }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
@endsection

@section('ajax')
    <script>
        $(document).ready(function() {
            $('#logsTable').DataTable({
                "order": [
                    [0, "desc"]
                ],
                "pageLength": 200
            });
        });
    </script>
@endsection
