@extends('layout.app')


@section('content')


    <form action="{{ route('supplier.update', $list->id) }}" method="POST">
        @method('PUT')
        @csrf
        <div class="card">
            <div class="card-body">
                <div class="row">
                <div class="form-group col-md-4">
                    <label for="name" class="">
                        Name*
                    </label>
                    <input type="text" name="name" id="name" value="{{ $list->name }}"
                        class="form-control" placeholder=" Name" autocomplete="off">
                    @error('name')
                        <div class="text-red-500 mt-2 text-sm">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group col-md-4">
                    <label for="email" class="">
                        Email*
                    </label>
                    <input type="text" name="email" id="email" value="{{ $list->email }}"
                        class="form-control" placeholder=" Email" autocomplete="off">
                    @error('email')
                        <div class="text-red-500 mt-2 text-sm">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group col-md-4">
                    <label for="mobile" class="">
                        Mobile*
                    </label>
                    <input type="text" name="mobile" id="mobile" value="{{ $list->mobile }}"
                        class="form-control" placeholder=" mobile" autocomplete="off">
                    @error('mobile')
                        <div class="text-red-500 mt-2 text-sm">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group col-md-4">
                    <label for="alt_mobile" class="">
                        Alt Mobile*
                    </label>
                    <input type="text" name="alt_mobile" id="alt_mobile" value="{{ $list->alt_mobile }}"
                        class="form-control" placeholder=" alt_mobile" autocomplete="off">
                    @error('alt_mobile')
                        <div class="text-red-500 mt-2 text-sm">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group col-md-4">
                    <label for="contact_person_name" class="">
                        Contact Person Name*
                    </label>
                    <input type="text" name="contact_person_name" id="contact_person_name"
                        value="{{ $list->contact_person_name }}" class="form-control"
                        placeholder=" contact_person_name" autocomplete="off">
                    @error('contact_person_name')
                        <div class="text-red-500 mt-2 text-sm">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                <div class="form-group col-md-4">
                    <label for="contact_person_mobile" class="">
                        Contact Person Mobile*
                    </label>
                    <input type="text" name="contact_person_mobile" id="contact_person_mobile"
                        value="{{ $list->contact_person_mobile }}" class="form-control"
                        placeholder=" contact_person_mobile" autocomplete="off">
                    @error('contact_person_mobile')
                        <div class="text-red-500 mt-2 text-sm">
                            {{ $message }}
                        </div>
                    @enderror
                </div>
                </div>
                <div class="form-group">
                    <div class="row float-right">
                        <a class="btn btn-primary" href="{{ url()->previous() }}">Back</a>
                        @can('supplier_update')
                            <button type="submit" class="ml-2 btn btn-success">
                                Update
                            </button>
                        @endcan
                    </div>
                </div>
            </div>
    </form>

    <div class="p-5"></div>

@endsection
