@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <form action="{{ route('sub-packages.update', $sub_packages->id) }}" method="POST">
                @method('PUT')
                @csrf
                <div class="row">
                    @can('edit-mother-package')
                        <div class="form-group col-md-4">
                            <label for="reseller">Select Reseller</label>
                            <select name="reseller_id" class="form-control" required>
                                <option value="">Select One</option>
                                @foreach ($resellers as $reseller)
                                    <option value="{{ $reseller->id }}" @if ($reseller->id == $sub_packages->reseller_id) selected @endif>
                                        {{ $reseller->name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group col-md-4">
                            <label for="package_id" class="block text-sm font-medium text-gray-700">
                                Package
                            </label>
                            <select name="package_id" class="form-control" required>
                                <option value="">Select One</option>
                                @foreach ($packages as $package)
                                    <option value="{{ $package->id }}" @if ($package->id == $sub_packages->package_id) selected @endif>
                                        {{ $package->package_name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('package_id')
                                <div class="alert alert-danger">{{ $message }}</div>
                            @enderror
                        </div>
                    @endcan
                    <div class="form-group col-md-4">
                        <label for="name" class="block text-sm font-medium text-gray-700">
                            Sub Package Name*
                        </label>
                        <input type="text" name="name" id="name" value="{{ $sub_packages->name }}"
                            class="form-control" placeholder="Reseller Name" autocomplete="off">

                        @error('name')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-md-4">
                        <label for="rate" class="block text-sm font-medium text-gray-700">
                            Rate
                        </label>
                        <input type="text" name="rate" id="rate" value="{{ $sub_packages->rate }}"
                            class="form-control " placeholder="Rate" autocomplete="off">
                        @error('rate')
                            <div class="alert alert-danger">{{ $message }}</div>
                        @enderror

                    </div>

                    @if (checkSettings('sub-package-commission') == 'enable')
                        <div class="form-group col-md-4">
                            <label for="rate" class="block text-sm font-medium text-gray-700">
                                Commission
                            </label>
                            <input type="number" name="commission" id="commission" value="{{ $sub_packages->commission }}"
                                class="form-control " placeholder="commission" autocomplete="off">
                            @error('commission')
                                <div class="alert alert-danger">{{ $message }}</div>
                            @enderror

                        </div>
                    @endif
                    @if (checkSettings('ResellerClientOnlineRecharge') == 'enable' && checkSettings('setClientPaymentAmountToClient') != 'enable' )
                        <div class="form-group col-md-4">
                            <label for="pool_name" class="block text-sm font-medium text-gray-700">
                                Client payment amount
                            </label>
                            <input type="number" name="client_payment_amount" id="client_payment_amount"
                                class="focus:ring-indigo-500 focus:border-indigo-500 form-control"
                                placeholder=" Client payment amount" value="{{ $sub_packages->client_payment_amount  }}" autocomplete="off">
                            @error('client_payment_amount')
                                <div class="alert alert-danger">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    @endif
                </div>

                <div class="form-group">
                    <button class="btn btn-primary float-right" type="submit"> Update</button>
                </div>
            </form>

        </div>
    </div>
@endsection
