@extends('layout.app')

@section('content')

    <div class="card">
        <div class=" card-body">
            <form action="" id="search" class="resellerRechargeLog">

                <div class="row">
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                                From Date
                            </label>
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input type="text" name="from_date" value="{{ $start->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append" data-toggle="datetimepicker"
                                    data-target="#searchFrom" autocomplete="off">

                            </div>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                                To Date
                            </label>

                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" name="to_date" value="{{ $end->format('m/d/y') }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">

                            </div>


                        </div>
                    </div>

                    <div class="col-md-3">
                        <div class="form-group">
                            <label>Select Manager</label>

                            <select name="reseller_id" v-model="reseller_id" class="form-control select2">
                                <option value="">All Manager</option>

                                @foreach ($reseller as $r)
                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    {{-- @can('check-recharge-by') --}}
                        <div class="col-md-3">
                            <div class="form-group">
                                <label>Recharge By</label>

                                <select name="user" v-model="user" class="form-control select2">
                                    <option value="">All User</option>
                                    @foreach ($users as $user)
                                        <option value="{{ $user->id }}">{{ $user->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    {{-- @endcan --}}


                    <div class="col-md-12">
                        <div class="form-group float-right mt-2">
                            <button @click="search" class="btn btn-primary" type="submit" id="ResellerSearch"><i
                                    class="fa fa-search"></i> Search</button>
                            <button class="btn btn-info" type="reset" id="reset">Reset</button>
                        </div>
                    </div>

                </div>





                <div id="reseller_list">
                    {{-- @include('resellerRecharge.result') --}}
                </div>



            </form>
        </div>
    </div>

    {{-- <x-Custom.modal modalTitle="Reseller Recharge">
    <x-Custom.inputGroup inputName="amount" labelName="Amount" labelIcon="" placeholder="0" inputType="number" required="required"/>
    <x-Custom.formUpdateBtn value="Recharge" class="float-right bg-blue-300 mt-2"/>
  </x-Custom.modal> --}}


@endsection



@section('ajax')

    <script type="text/javascript">
        $(function() {
            $('#reset').click(function() {
                $('#reseller_list').html('');
            });
            $('#ResellerSearch').on('click', function(e) {
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '{{ route('resellerRechargeSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#reseller_list').html(result);

                    }
                });
            });
        });
    </script>

    <script>
        function export2csv() {
            let data = "";
            const tableData = [];
            const rows = document.querySelectorAll("table#tableId tr");
            for (const row of rows) {
                const rowData = [];
                for (const [index, column] of row.querySelectorAll("th, td").entries()) {
                    // To retain the commas in the "Description" column, we can enclose those fields in quotation marks.
                    if ((index + 1) % 3 === 0) {
                        rowData.push('"' + column.innerText + '"');
                    } else {
                        rowData.push(column.innerText);
                    }
                }
                tableData.push(rowData.join(","));
            }
            data += tableData.join("\n");
            const a = document.createElement("a");
            a.href = URL.createObjectURL(new Blob([data], {
                type: "text/csv"
            }));
            a.setAttribute("download", "data.csv");
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }
    </script>
@endsection
