@extends('layout.app')


@section('content')
<button class="noprint btn-blue float-right mt-5"  onclick="window.print()"><i class="fa fa-print"></i></button>
<div class="md:grid md:grid-cols-2 md:gap-6 mt-5">

    <div class="mt-5 md:mt-0 md:col-span-2">
    <a class="noprint block uppercase px-5 py-1 mb-2 rounded bg-blue-600 text-blue-50 max-w-max shadow-sm hover:shadow-lg" href="{{ url()->previous() }}"> <i class="fa fa-arrow-left"></i> Back</a>
               
    <div class=" sm:rounded-md sm:overflow-hidden p-5 details">
        <h5>Requisition Approve Information</h5>
                    <table class="table table-bordered" id="">
                        <tr>
                            <th colspan="6" class="text-center">Requisition Approve No#{{ $requisitionApprove->requisition_approve_number }}</th>
                        </tr>
                    </table>
                    <h5>Items</h5>
                    <table class="min-w-full divide-y divide-gray-200" id="">
                    <thead class="bg-gray-50">
                        <tr>
                            <th>Item</th>
                            <th>Category</th>
                            <th>Unit</th>
                            <th>Quantity</th>
                        </tr>
                    </thead>
                        @foreach ($requisitionApprove->items as $row)
                        <tr>
                            <td>{{ $row->item->name ??'' }}</td>
                            <td>{{ $row->item->category->name ??'' }}</td>
                            <td>{{ $row->item->unit->name ??'' }}</td>
                            <td>{{ $row->quantity ??'' }}</td>
                        </tr>
                        @endforeach

                        <tr>
                            <th>Remarks</th>
                            <td colspan="5">{{ $requisitionApprove->remark ??'' }}</td>
                        </tr>
                    </table>
        </div>
    </div>
</div>




@endsection