@extends('layout.app')
@section('content')
<div class="flex flex-col mt-2" id="vue_app">
  <div class=" bg-white p-2 rounded-lg">
    <form action="{{ route('requisition-approves.store') }}" method="POST">
      @csrf
      <div class="border-2 mb-2">
        <div class="bg-blue-100 block pt-4 p-5">

        <div class="">
                    <div class="">
                        <div class="">
                            <div class="">
                                <label class="">Requisition Number</label>
                                <select class="" v-model="requisition_id"
                                    @change="fetch_requisition" name="requisition_id" required>
                                    <option value="">Select Requisition Number</option>
                                    @forelse ($requisitions as $item)
                                    <option value="{{ $item->id }}">{{ $item->requisition_number }}</option>
                                    @empty

                                    @endforelse

                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="">

                    <div class="" v-if="items.length > 0">
                        <table class="">
                            <tr>
                                <th>Item</th>
                                <th>Category</th>
                                <th>Unit</th>
                                <th>Stock Qty</th>
                                <th>Requisition Qty</th>
                                <th>Approve Qty</th>
                                <th>Action</th>
                            </tr>
                            <tr v-for="(row, index) in items">
                                <td>
                                    <input type="hidden" :name="'products['+index+'][item_id]'"
                                        class="" v-bind:value="row.item_id">

                                    <input type="text" class="" v-bind:value="row.name" readonly>
                                </td>
                                <td><input type="text" class="" v-bind:value="row.category"
                                        readonly></td>
                                <td><input type="text" class="" v-bind:value="row.unit" readonly>
                                </td>
                                <td><input type="text" class="" v-bind:value="row.stock_qty"
                                        readonly>
                                </td>
                                <td><input type="text" class="" v-bind:value="row.quantity"
                                        readonly>
                                </td>
                                <td>

                                    <input type="number" :name="'products['+index+'][approve_qty]'"
                                        v-model="row.approve_qty" class="" @change="valid(row)"
                                        required>

                                </td>
                                <td>
                                    <button type="button" class="btn btn-danger btn-xs" @click="delete_row(row)"><i
                                            class="fa fa-times"></i></button>
                                </td>
                            </tr>
                        </table>
                    </div>
                    <div class="row" v-if="items.length > 0">
                        <div class="">
                            <div class="">
                                <label class="">Remarks</label>
                                <textarea class="" name="remark" rows="3"
                                    placeholder="Enter Remarks"></textarea>
                            </div>
                        </div>
                        <div class="">
                        <button class="inline-block px-6 py-2 text-white bg-blue-600 float-right mr-2 mb-2" type="submit"><i class="fa fa-save"></i> Save</button>
                        </div>
                    </div>
                </div>
      </div>
    </form>
  </div>
</div>
@endsection

@push('js')

<script src="{{ asset('vue-js/vue/dist/vue.js') }}"></script>
<script src="{{ asset('vue-js/axios/dist/axios.min.js') }}"></script>
<script src="{{ asset('vue-js/bootstrap-select/dist/js/bootstrap-select.min.js') }}"></script>
<script>
    $(document).ready(function () {
            var app = new Vue({
                el: '#vue_app',
                data: {
                    config: {
                        get_requisition_info_by_requisition_id_url: "{{ url('admin/fetch-requisition-by-requisition-id') }}",
                    },
                    requisition_id:'',
                  
                  
                    results:[],
                    items:[],
                  
                 
                },
                computed: {
              
                },

                methods: {
                    fetch_requisition(){
                    
                    var vm = this;
                    var slug = vm.requisition_id;
                    if (slug) {
                        // vm.items = [];
                    axios.get(this.config.get_requisition_info_by_requisition_id_url + '/' + slug).then(function (response) {
   console.log(response.data);
                    vm.items = response.data.items;
                 
                    }).catch(function (error) {

                    toastr.error('Something went to wrong', {
                    closeButton: true,
                    progressBar: true,
                    });

                    return false;

                    });
                    }

                    },

                    delete_row: function (row) {
                    this.items.splice(this.items.indexOf(row), 1);
                    },

                    valid: function (index) {
                    console.log(index.stock_qty);
                    if(index.approve_qty > index.stock_qty ){
                    index.approve_qty = index.stock_qty ;
                    }
                    if(index.approve_qty > index.quantity ){
                    index.approve_qty = index.quantity ;
                    }
                    if(index.approve_qty<=0){ index.approve_qty=1; } 
                    },
                  
                },

                updated() {
                    $('.bSelect').selectpicker('refresh');
                }
            });

            $('.bSelect').selectpicker({
                liveSearch: true,
                size: 5
            });
        });
</script>
@endpush