@extends('layout.app')

@section('content')
<div class="card">
    <div class="card-body">
        <div class="row">

            <div class="col-md-6">
                <div class="form-group">
                    <label class="block text-gray-700 text-sm font-bold mb-2" for="from_date">
                        From Date
                    </label>
                    <div class="input-group date" id="searchFrom" data-target-input="nearest">
                        <input type="text" name="from_date" value="{{$from->format('m/d/y')}}"
                            class="form-control datetimepicker-input input-group-append"
                            data-toggle="datetimepicker" data-target="#searchFrom"
                            autocomplete="off">

                    </div>
                </div>
            </div>

            <div class="col-md-6">
                <div class="form-group">
                    <label class="block text-gray-700 text-sm font-bold mb-2" for="to_date">
                        To Date
                    </label>
                    <div class="input-group date" id="searchTo" data-target-input="nearest">
                        <input type="text" name="to_date" value="{{$to->format('m/d/y')}}"
                            class="form-control datetimepicker-input input-group-append"
                            data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                    </div>
                </div>
            </div>

            <div class="col-md-12">
                <div class="form-group float-right mt-2">

                    <button  class="btn btn-primary" type="submit"
                            id="searchBtn"><i class="fa fa-search"></i> Search</button>

                </div>
            </div>


        </div>



        <div class="table-responsive">
            <div id="result">

            </div>
        </div>
    </div>
</div>

@endsection

@section('ajax')
<script src="{{ asset('/') }}js/xlsx/xlsx.full.min.js"></script>
<script src="{{ asset('/') }}js/html2pdf/html2pdf.bundle.min.js"></script>

<script>

    $(document).ready(function () {
        $('#searchBtn').on('click', function(e) {
            e.preventDefault();
            let from = $('#searchFrom input').val();
            let to = $('#searchTo input').val();

            //add page loading effect
            $('#result').html('<div class="text-center"><i class="fas fa-spinner fa-spin"></i> Loading...</div>');

            $.ajax({
                type: 'get',
                url: '{{ route('kam-sales-report-search') }}',
                data: {
                    from: from,
                    to: to
                },
                success: function(result) {
                    $('#result').html(result);
                }
            });
        });
    });
</script>

@endsection
