@extends('layout.app')

@section('content')
    <div class="card">
        <div class=" card-body">



                <div class="table-responsive">
                    <div>
                        <button id="downloadBtn" class="btn btn-primary">Download In Excele</button>
                       
                        {{-- <button id="printBtn" class="btn btn-primary">Print</button> --}}
                    </div>
                    <div class="print-content" id="result">
                        <div class="print-content" id="result">
                            <table class="table table-bordered table-condensed table-striped" id="tableId">
                                <thead class="bg-dark">
                                    <tr >

                                        <th>
                                            Money Receipt
                                        </th>

                                        <th>
                                            Number of Payment
                                        </th>


                                    </tr>
                                </thead>

                                <tbody class="bg-white divide-y divide-gray-200">

                                    @foreach ($billPayments as $payment)

                                            <tr>



                                                <td>
                                                    {{ $payment->money_receipt_number ?? '' }}
                                                </td>
                                                <td>
                                                    {{ $payment->count_money_receipt_number ?? 0 }}
                                                </td>
                                            </tr>




                                    @endforeach

                                </tbody>

                            </table>
                        </div>

                    </div>
                </div>

        </div>
    </div>

    <style>

        @media print {
          body * {
              visibility: hidden;
          }

          .no-page-break {
              page-break-inside: avoid !important;
          }

          .print-content, .print-content * {
              visibility: visible;
          }

          .print-content {
              position: absolute;
              left: 10px;
              top: 0;
          }

          .print-content table {
              width: 100%;
              border-collapse: collapse;
              font-size: 16pt;
          }

          .print-content th,
          .print-content tr,
          .print-content td {
              padding: 8px;
              font-size: 14pt !important;
              font-weight: bold;
          }

          .print-content th {
              background-color: #f2f2f2; /* Optionally set a background color for table headers */
          }

          .print-content td {
              border: 1px solid #ddd; /* Optionally add borders to table cells */
          }

          .no-print {
              display: none;
          }
      }
      </style>
@endsection



@section('ajax')

<script src="{{ asset('/') }}js/xlsx/xlsx.full.min.js"></script>
<script src="{{ asset('/') }}js/html2pdf/html2pdf.bundle.min.js"></script>
<script>


    document.getElementById('downloadBtn').addEventListener('click', function() {
        // Function to create and download Excel file
        exportToExcel();
    });

    function exportToExcel() {
        const table = document.getElementById('tableId');
        const wb = XLSX.utils.table_to_book(table, { sheet: 'Stock Data' });
        XLSX.writeFile(wb, 'due_customers.xlsx');
    }

    document.getElementById('downloadPdfBtn').addEventListener('click', function() {
        // Function to create and download PDF file
        exportToPdf();
    });

    function exportToPdf() {

        const element = document.getElementById('tableId');

            html2pdf(element, {
                filename: 'duplicate_money_receipt.pdf',
                jsPDF: { unit: 'mm', format: 'a4', orientation: 'portrait' },
                pagebreak: { mode: 'avoid-all', before: '.pagebreakclass' }
            });
    }

    // document.getElementById('printBtn').addEventListener('click', function() {
    //     // Function to initiate the print process
    //     printTable();
    // });

    function printTable() {
        window.print();
    }



</script>
@endsection
