@extends('layout.app')


@section('content')
    <div class="mt-2 card">
        <div class="card-body">
            <p>Grand Total Quantity: {{ $grandTotal }}</p>
            <div class="table-responsive">
                <table id="dataTable" class="table table-bordered">
                    <thead>
                        <tr>
                            <th>
                                ID
                            </th>
                            <th>
                                Item Name
                            </th>
                            <th>
                                Category Name
                            </th>


                            <th>
                                Stock Quantity
                            </th>
                            <th>Action</th>

                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($list as $r)
                            <tr>
                                <td class="text-center">
                                    {{ $r->id }}
                                </td>
                                <td class="text-center">
                                    {{ $r->name ?? '' }}
                                </td>
                                <td class="text-center">
                                    {{ $r->category->name ?? '' }}
                                </td>
                                <td>{{ $r->stockIn->sum('quantity') - $r->stockOut->sum('quantity') + $r->itemReturn->sum('qty') - $r->itemAdjustment->sum('quantity') }}
                                </td>

                                {{-- <td class="text-center">
                                {{ \App\Classes\AvailableStockCalculation::item_id($r->item_id) }}
                            </td> --}}

                                <td>
                                    <div>
                                        @if ($r->serial_number == 'enable')
                                            <a href="{{ route('show-serial-no', $r->id) }}" class="btn bg-primary"> Show
                                                Serial Number</a>
                                        @endif
                                    </div>
                                </td>

                            </tr>
                        @endforeach

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>

            {{-- <div class="p-5">
                {{ $list->links() }}
            </div> --}}
        </div>
    </div>
@endsection
