@extends('layout.app')

@section('content')

    <div class="card card-default">
        <div class="card-body">


            <form action="{{ route('serialNumber.store') }}" method="POST" id="serialForm">
                @csrf
                <select name="item_id" id="item_id" class="form-control" required>
                    <option value="">Select Item</option>
                    @foreach ($items->items as $item)
                        @if ($item->itemWithSerialNumber)
                            <option value="{{ $item->itemWithSerialNumber->id }}">
                                {{ $item->itemWithSerialNumber->name }}</option>
                        @endif
                    @endforeach
                </select>
                <div class="form-group d-flex justify-content-center">

                    <input type="hidden" class="mt-2 form-control col-md-3" id="purchase_id" value="{{ $items->id }}" name="purchase_id">
                    <input type="hidden"  id="url" value="{{ $url }}" name="url">

                </div>

                <div class="form-group d-flex justify-content-center ">

                    <input type="text" class="mt-2 d-none form-control col-md-3" id="serial_numer"
                        placeholder="Enter Serial Number" name="serial_number" autocomplete="off" required>

                </div>
                <input type="hidden" id="showAllOrNot" name="showAllOrNot" value="0">

                <button  class="btn bg-primary float-right mt-2 mb-2">
                    Add
                </button>

                <button href="" class="btn d-none bg-info float-left mt-2 mb-2 mr-2" id="showAllSerialBtn">
                    Show All
                </button>

            </form>
            <div class="d-none" id="tableId">

                <table class="table" id="result">
                    <thead>
                        <th>#</th>
                        <th>Serial No</th>
                        <th>Status</th>
                        <th>Action</th>
                    </thead>
                    <tbody id="df">

                    </tbody>
                </table>

            </div>
            <div class="modal fade" id="changeSerialNoModal">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <button type="button" class="close" data-dismiss="modal"
                                aria-label="Close"><span aria-hidden="true">&times;</span></button>

                        </div>
                        <div class="modal-body">

                            <div class="form-group">
                                <label for="amount">Previous Serial Number</label>
                                <input type="text" class="form-control"  id="pre_serial_no" />
                                <input type="hidden" class="form-control"  id="pre_serial_id"  />
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                            <button type="button" id="change_serial_no" class="btn btn-primary">Save</button>
                        </div>
                    </div>
                </div>
            </div>

        </div>


    </div>


@endsection


@push('js')


    <script>
        $(document).ready(function() {
            var rowNumber=-1;

            $('#showAllSerialBtn').click(function(){

                $('#showAllOrNot').val(1);
                $('#serialForm').submit();

            });

            $('#item_id').on('change', function() {
                $("#serial_numer").removeClass("d-none");
                $("#tableId").removeClass("d-none");
                $("#showAllSerialBtn").removeClass("d-none");
                $('#serial_numer').focus();

                var product_id = $('#item_id').val();
                var purchase_id = $('#purchase_id').val();
                $.ajax({
                    url: '{{ route('all-serial') }}',
                    type: 'get',
                    data: {
                        productId: product_id,
                        purchaseId: purchase_id
                    },
                    success: function(data) {

                        $('#result').html(data);


                        $('.showEdit').on('click',function(){

                            $('#changeSerialNoModal').modal('show');
                            previousSerialNumber = $(this).closest('tr').find(".serial_no").html();
                            pre_serial_id = $(this).closest('tr').find(".serial_id").html();
                            rowNumber = $(this).closest('tr').find(".row_id").html();
                            $('#pre_serial_no').val(previousSerialNumber);
                            $('#pre_serial_id').val(pre_serial_id);



                        });

                        $('.delete').on('click', function(){

                            var product_id = $('#item_id').val();
                            var purchase_id = $('#purchase_id').val();
                            var pre_serial_id = $(this).closest('tr').find(".serial_id").html();
                            rowNumber = $(this).closest('tr').find(".row_id").html();

                            $.ajax({
                                url: '{{ route('serial-no-delete') }}',
                                type: 'post',
                                data: {id: pre_serial_id},
                                success: function(data){

                                    if(data==1){
                                        $('#'+rowNumber+'').hide();
                                        toastr.success("Serial No Delete Successfull");
                                    }else{
                                        toastr.error("Serial Number Allready Used");
                                    }
                                }
                            });
                        });

                        $('#change_serial_no').on('click',function(){

                            new_serial=$('#pre_serial_no').val();
                            item_id=$('#item_id').val();
                            id=$('#pre_serial_id').val();

                            if(new_serial != null){

                                $.ajax({
                                    url: '{{ route('edit-serial') }}',
                                    type: 'post',
                                    data: { data: new_serial, productId: item_id, id: id },
                                    success: function(data) {

                                        if (data.result == 1) {

                                            toastr.success("Serial No Update Successfull");
                                            $('#result #'+rowNumber+' .serial_no').html(data.value);
                                            $('#changeSerialNoModal').modal('toggle');

                                        } else if (data.result == 2) {
                                            toastr.error("This Serial No Allready Add For This Item");
                                            $('#changeSerialNoModal').modal('toggle');
                                        } else {
                                            toastr.error("Previous Serial Number Allready Used");
                                            $('#changeSerialNoModal').modal('toggle');
                                        }
                                    }
                                });
                            }


                        });
                    }
                });
            });



            $('#serialForm').on('keydown', 'input', function(event) {

                if (event.which == 13) {
                    event.preventDefault();

                }

            });


            $('#serial_numer').on('keyup', function(e) {

                if (e.which == 13) {

                    var data = $('#serial_numer').val();
                    var product_id = $('#item_id').val();
                    var purchase_id = $('#purchase_id').val();
                    // console.log(s);

                    if(data !=null){

                        $.ajax({
                            url: '{{ route('add-serial') }}',
                            type: 'get',
                            data: {
                                data: data,
                                productId: product_id,
                                purchaseId: purchase_id
                            },
                            success: function(data) {
                                if (data == 1) {
                                    toastr.success("Serial No Add Successfull");
                                    $('#serial_numer').val("");
                                    var product_id = $('#item_id').val();
                                    var purchase_id = $('#purchase_id').val();
                                    $.ajax({
                                        url: '{{ route('all-serial') }}',
                                        type: 'get',
                                        data: {
                                            productId: product_id,
                                            purchaseId: purchase_id
                                        },
                                        success: function(data) {
                                            $('#result').html(data);

                                            $('.showEdit').on('click',function(){

                                                $('#changeSerialNoModal').modal('show');
                                                previousSerialNumber = $(this).closest('tr').find(".serial_no").html();
                                                pre_serial_id = $(this).closest('tr').find(".serial_id").html();
                                                rowNumber = $(this).closest('tr').find(".row_id").html();
                                                $('#pre_serial_no').val(previousSerialNumber);
                                                $('#pre_serial_id').val(pre_serial_id);

                                            });

                                            $('.delete').on('click', function(){

                                                var product_id = $('#item_id').val();
                                                var purchase_id = $('#purchase_id').val();
                                                var pre_serial_id = $(this).closest('tr').find(".serial_id").html();
                                                rowNumber = $(this).closest('tr').find(".row_id").html();

                                                $.ajax({
                                                    url: '{{ route('serial-no-delete') }}',
                                                    type: 'get',
                                                    data: {id: pre_serial_id},
                                                    success: function(data){

                                                        if(data==1){
                                                            $('#'+rowNumber+'').hide();
                                                            toastr.success("Serial No Delete Successfull");
                                                        }
                                                    }
                                                });
                                            });

                                            $('#change_serial_no').on('click',function(){

                                                new_serial=$('#pre_serial_no').val();
                                                item_id=$('#item_id').val();
                                                id=$('#pre_serial_id').val();

                                                if(new_serial != null){

                                                    $.ajax({
                                                        url: '{{ route('edit-serial') }}',
                                                        type: 'get',
                                                        data: { data: new_serial, productId: item_id, id: id },
                                                        success: function(data) {

                                                            if (data.result == 1) {

                                                                toastr.success("Serial No Update Successfull");
                                                                $('#result #'+rowNumber+' .serial_no').html(data.value);
                                                                $('#changeSerialNoModal').modal('toggle');

                                                            } else if (data.result == 2) {
                                                                toastr.error("This Serial No Allready Add For This Item");
                                                                $('#changeSerialNoModal').modal('toggle');
                                                            } else {
                                                                toastr.error("All Serial No add for this Purchase");
                                                                $('#changeSerialNoModal').modal('toggle');
                                                            }
                                                        }
                                                    });
                                                }


                                            });

                                        }
                                    });
                                } else if (data == 2) {
                                    // console.log(data);
                                    toastr.error("This Serial No Allready Add For This Item");
                                } else {
                                    console.log(data);
                                    toastr.error("All Serial No add for this Purchase");

                                }
                            }
                        });
                    }

                }
            });
        });
    </script>

@endpush
