@extends('layout.app')


@section('content')

    <div class="mt-2 card">
        <div class="card-body">
            <div class="table-responsive">
            <table id="dataTable" class="table table-bordered">
                <thead>
                    <tr>
                        <th class="text-center">
                            ID
                        </th>
                        <th class="text-center">
                            Purchase No.
                        </th>
                        <th class="text-center">
                            Voucher No
                        </th>
                        <th class="text-center">
                            Branch
                        </th>
                        <th class="text-center">
                            Create Date
                        </th>
                        <th class="text-center">
                            Action
                        </th>
                    </tr>
                </thead>
                <tbody>

                    @foreach ($list as $r)

                        <tr>
                            <td class="text-center">
                                {{ $r->id }}
                            </td>
                            <td class="text-center">
                                {{ $r->invoice_number }}
                            </td>
                            <td class="text-center">
                                {{ $r->voucher_no }}
                            </td>
                            <td class="text-center">
                                {{ $r->branch->name ?? '' }}
                            </td>

                            <td class="text-center">
                                {{ date('d-M-Y H:i:s A', strtotime($r->created_at)) }}
                            </td>
                            <td class="text-center">
                                <div class="row">
                                    <a href="{{ route('purchase.show', $r->id) }}">
                                        <button class="btn btn-success ">Show</button>
                                    </a>

                                    @if ($r->approve_status!="yes")

                                    <a href="{{ route('purchase.edit', $r->id) }}">
                                        <button class="btn btn-info ml-2">Edit</button>
                                    </a>
                                    @endif

                                    @if ($r->approve_status!="yes")

                                    <a href="{{ route('serial-no-add', $r->id) }}">
                                        <button class="btn btn-info ml-2">Add serial No</button>
                                    </a>
                                    @endif

                                    <a href="{{ route('approve-purchase', $r->id) }}">
                                        <button class="btn btn-warning ml-2" @if ($r->approve_status=="yes")
                                            disabled
                                        @endif>Approve</button>
                                    </a>

                                </div>

                            </td>
                        </tr>

                    @endforeach

                </tbody>
            </table>
            </div>

            <div class="p-5">
                {{-- {{ $list->links() }} --}}
            </div>
        </div>
    </div>





@endsection
