@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <div class="table-responsive pt-2 " id="result">
                <table id="dataTable" class="display table table-bordered " style="width: 100% !important">
                    <thead style="background:#78716c;color:#FFFFFF;">
                        <tr class="text-center">
                            <th scope="col">Id</th>
                            <th scope="col"> POP Name </th>
                            @if (checkSettings('pop-online-recharge') == 'enable')
                                <th></th>
                            @endif
                            <th scope="col"> Manager Name </th>
                            <th scope="col"> POP Location </th>
                            @hasrole('Admin')
                                <th scope="col">NAS Server IP </th>
                            @endhasrole
                            <th scope="col"> POP Contact </th>
                            <th scope="col"> Sub-Manager </th>
                            @hasrole('Admin')
                                <th scope="col">Bill Generate </th>
                            @endhasrole
                            @canany(['show-pop-balance', 'specific_management_services'])
                                <th scope="col">Balance </th>
                            @endcan
                            <th scope="col"> Action </th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @php($checkAPI = checkAPI())
                        @foreach ($pops as $r)
                            <tr>
                                <td>
                                    {{ $r->id }}
                                </td>
                                <td>
                                    {{ $r->popname }}
                                </td>

                                @if (checkSettings('pop-online-recharge') == 'enable')
                                    {{-- @dd("comes"); --}}
                                    <td>
                                        @if ($r->enable_online_recharge)
                                            <a href="{{ route('onlinePopRecharge', $r->id) }}" class="btn btn-danger">Online
                                                Recharge</a>
                                        @endif
                                    </td>
                                @endif

                                <td>
                                    {{ $r->reseller->name ?? '' }}
                                </td>

                                <td>
                                    {{ $r->pop_location }}
                                </td>

                                @hasrole('Admin')
                                    <td>
                                        {{ $r->nas->nasname ?? '' }}
                                    </td>
                                @endhasrole




                                <td>
                                    {{ $r->pop_contact }}
                                </td>
                                <td>
                                    {{ $r->subreseller }}
                                </td>

                                {{-- <td>
                                    {{ $r->billable }}
                                </td> --}}
                                @hasrole('Admin')
                                    <td>
                                        {{ $r->bill_generate }}
                                    </td>
                                @endhasrole
                                @canany(['show-pop-balance', 'specific_management_services'])
                                    <td class="font-weight-bold border p-1 text-center ">
                                        @if ($r->subreseller == 'yes')
                                            {{ $r->balance->first()->amount ?? '' }}
                                        @endif
                                    </td>
                                @endcan

                                <td class="whitespace-nowrap text-right text-sm font-medium">
                                    <div class="dropdown">
                                        <button class="btn btn-primary dropdown-toggle" type="button"
                                            id="dropdownMenuButton" data-toggle="dropdown" aria-haspopup="true"
                                            aria-expanded="false">
                                            Action
                                        </button>
                                        <div class="btn-primary dropdown-menu" aria-labelledby="dropdownMenuButton">
                                            @if (Auth()->user()->can('pop_edit') ||
                                                    Auth()->user()->can('pop-accounts-edit'))
                                                <a class="dropdown-item" href="{{ route('pop.edit', $r->id) }}">Edit</a>
                                            @endif

                                            @can('pop-deactive')
                                                <a class="dropdown-item" href="{{ route('pop-deactive', $r->id) }}">Deactive
                                                    All Customer</a>
                                            @endcan
                                            @can('pop-close')
                                                <a class="dropdown-item" href="{{ route('pop-close', $r->id) }}">Close All
                                                    Customer</a>
                                            @endcan
                                            @can('view-pop-log-history')
                                                <a class="dropdown-item"
                                                    href="{{ route('editLog-history', ['id' => $r->id, 'type' => 'POP']) }}">History</a>
                                            @endcan
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        @endforeach

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@endsection


@section('ajax')
    <script>
        $(function() {
            $('#newDataTable').DataTable({
                responsive: true,
                "bProcessing": true,
                "iDisplayLength": 100,
                'order': [
                    [1, "asc"]
                ]
            });
        });
    </script>
@endsection

