@extends('layout.app')

@section('content')
<div class="card">
    <div class="card-body">

        <form action="" >
            <div class="row">
                <div class="col-md-4">
                    <label for="">Employee</label>
                    <select name="employee_id" id="employee_id" class="form-control">
                        <option value="">Select Employee</option>
                        @foreach ($employees as $employee)
                            <option value="{{ $employee->id }}">{{ $employee->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-4">
                    <label for="">From Date</label>
                    <input type="date" name="from_date" id="from_date" class="form-control"
                        placeholder="Enter From Date">
                </div>
                <div class="col-md-4">
                    <label for="">To Date</label>
                    <input type="date" name="to_date" id="to_date" class="form-control"
                        placeholder="Enter To Date">
                </div>
            </div>
            <button type="button" id="employeePaymentForm" class="btn btn-primary mt-3" style="float: right">Submit</button>
        </form>
    </div>
</div>
    <div id="result" class="mt-5">

    </div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
    $(document).ready(function () {
        $('#employeePaymentForm').on('click', function (e) {
            e.preventDefault();
            let todate = $('#to_date').val();
            let fromdate = $('#from_date').val();
            let employee_id = $('#employee_id').val();

            $.ajax({
                type: 'GET',
                url: "{{ route('payroll.salaryResult') }}",
                data: {
                    employee_id: employee_id,
                    from_date: fromdate,
                    to_date: todate
                },
                success: function (response) {
                    $('#result').html(response);
                    $('#dataTable').DataTable({
                        dom: 'Bfrtip',
                        buttons: [
                            {
                                extend: 'csvHtml5',
                                text: 'Download CSV',
                                className: 'btn btn-primary'
                            }
                        ],
                        "destroy": true,
                        "lengthChange": false,
                        "pageLength": 10,
                        "searching": false,
                        "ordering": false,
                    });
                }
            });
        });
    });
</script>
@endsection
