@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            @can('employee-salary-generate')
                <div class="row">
                    <div class="col-md-12">
                        <a href="{{ route('payroll.salaryGenerate') }}" class="btn btn-success mb-4" style="float: right">All
                            Employee Salary Generate</a>
                    </div>
                </div>
            @endcan
            <div class="table-responsive">
                <table id="dataTable" class="display table">
                    <thead class="bg-gray-50">
                        <tr>
                            <th>Employee Id</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Number</th>
                            <th>Joining Date</th>
                            <th>Basic Salary</th>
                            <th>Total Salary</th>
                            <th>Total Payment</th>
                            <th>Current Balance</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>

                        @foreach ($employees as $employee)
                            <tr>
                                <td>{{ $employee->id }}</td>
                                <td>{{ $employee->name }}</td>
                                <td>{{ $employee->email }}</td>
                                <td>{{ $employee->mobile_personal }}</td>
                                <td>{{ $employee->join_date }}</td>
                                <td>{{ $employee->current_salary }}</td>
                                <td>{{ $employee->payroll_sum_net_salary }}</td>
                                <td>{{ $employee->employee_payment_sum_amount }}</td>
                                <td>{{ $employee->payroll_sum_net_salary - $employee->employee_payment_sum_amount ?? 0 }}</td>
                                <td>
                                    <a href="{{ route('payrollEmployee.show', $employee->id) }}"
                                        class="btn btn-info btn-sm">View</a>
                                    <a href="{{ route('payrollEmployee.edit', $employee->id) }}"
                                        class="btn btn-warning btn-sm">Edit</a>
                                    <button class="btn btn-danger btn-sm view-details-btn"
                                        data-id="{{ $employee->id }}">Payment</button>
                                    <button class="btn btn-secondary btn-sm previousSalary" data-id="{{ $employee->id }}"="">Add Salary</button>
                                </td>
                            </tr>
                        @endforeach

                        <!-- More items... -->
                    </tbody>
                </table>
            </div>

        </div>
    </div>

    <div class="modal fade" id="previousSalaryModal" tabindex="-1" aria-labelledby="previousSalaryModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="previousSalaryModalLabel">Salary Sheet Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                </div>
                <div class="modal-body">
                    <div id="previousSalaryDetails">
                        <div class="text-center">
                            <span class="spinner-border text-primary d-none" id="modalLoader"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- SalarySheet Info Modal -->
    <div class="modal fade" id="salarySheetModal" tabindex="-1" aria-labelledby="salarySheetModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="salarySheetModalLabel">Salary Sheet Details</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                      </button>
                </div>
                <div class="modal-body">
                    <div id="salarySheetDetails">
                        <div class="text-center">
                            <span class="spinner-border text-primary d-none" id="modalLoader"></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

    <script>
        // Bank accounts data
        var bankAccounts = @json($bankAccounts ?? []);

        $(document).ready(function() {
            $('.view-details-btn').click(function() {
                var salarySheetId = $(this).data('id');

                // let modal = new bootstrap.Modal(document.getElementById('salarySheetModal'));
                // modal.show();

                $('#salarySheetDetails').html(
                    '<div class="text-center"><span class="spinner-border text-primary"></span></div>'
                );

                $.ajax({
                    url: `{{ url('admin/salary-sheet') }}/${salarySheetId}`,
                    type: 'GET',
                    dataType: 'json',
                    success: function(data) {
                        var currentSalary = data.payroll_sum_net_salary - data.employee_payment_sum_amount;

                        var bankAccountsHtml = '<option value="">Select Bank Account</option>';
                        if (bankAccounts && bankAccounts.length > 0) {
                            bankAccounts.forEach(function(bank) {
                                bankAccountsHtml += '<option value="' + bank.id + '">' + bank.account_name + ' - ' + bank.bank_name + ' (' + bank.account_no + ')</option>';
                            });
                        } else {
                            bankAccountsHtml = '<option value="">No Bank Account Available</option>';
                        }

                        var html = `
                            <form action="{{ route('employee.payment') }}" method="POST">
                                @csrf
                                <p><strong>Employee ID:</strong> <input class="form-control" type="text" id="salarySheetId" name="employee_id" value="${data.id}" readonly></p>
                                <p><strong>Name:</strong> <input class="form-control" type="text" id="salarySheetName" value="${data.name}" readonly></p>
                                <p><strong>Email:</strong> <input class="form-control" type="text" id="salarySheetEmail" value="${data.email}" readonly></p>
                                <p><strong>Current Balance :</strong> <input class="form-control" type="text" id="salarySheetNetSalary" value="${currentSalary}" readonly></p>
                                <p><strong>Salary:</strong> <input class="form-control" type="text" id="salarySheetSalary" name="amount" value=""></p>
                                <p><strong>Bank Account:</strong> <select class="form-control" name="bank_account_id" id="bank_account_id">${bankAccountsHtml}</select></p>
                                <p><strong>Remarks:</strong> <input class="form-control" type="text" id="remark" name="remark"> </p>
                                <button class="btn btn-success">Payment</button>
                            </form>
                        `;
                        $('#salarySheetDetails').html(html);

                        // ✅ Bootstrap 5 Modal API here
                        let modal = new bootstrap.Modal(document.getElementById(
                            'salarySheetModal'));
                        modal.show();
                    },
                    error: function() {
                        $('#salarySheetDetails').html(
                            '<p class="text-danger">Failed to load data.</p>');
                    }
                });
            });

            $('.previousSalary').click(function() {
                console.log('Button clicked');
                var employeeId = $(this).data('id');

                $('#salarySheetDetails').html(
                    '<div class="text-center"><span class="spinner-border text-primary"></span></div>'
                );

                let html = `
                    <form action="{{ route('payroll.previousSalary') }}" method="POST">
                        @csrf
                        <p><strong>Employee ID:</strong> <input class="form-control" type="text" id="salarySheetId" name="employee_id" value="${employeeId}" readonly></p>
                        <p><strong>Salary:</strong> <input class="form-control" type="text" id="salarySheetSalary" name="amount" value=""></p>
                        <p><strong>Remarks:</strong> <input class="form-control" type="text" id="remark" name="remark"> </p>
                        <button class="btn btn-success">Add Salary</button>
                    </form>
                `;

                $('#previousSalaryDetails').html(html);

                let modal = new bootstrap.Modal(document.getElementById(
                            'previousSalaryModal'));
                modal.show();
            });
        });
    </script>
@endsection
