@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <form action="#" id="search" class="w-2/3 m-auto">

                <div class="form-group col-md-4">
                    <label>Search By Username</label>
                    <input type="text" name="username" class="form-control">
                </div>

                <div class="form-group float-right">
                    <button @click="search" class="btn btn-primary" type="submit" id="searchbtn"><i
                            class="fa fa-search"></i> Search</button>
                    <button class="btn btn-info" type="reset" id="reset">Reset</button>
                </div>
            </form>
        </div>

        <div class="card-body">
            <div id="result"></div>
        </div>
    </div>
@endsection

@section('ajax')
    <script>
        $(function() {

            $('#reset').click(function() {
                $('#result').html('');
            });

            $('#searchbtn').on('click', function(e) {
                e.preventDefault();
                $.ajax({
                    type: 'get',
                    url: '{{ route('paymentInvoiceSearch') }}',
                    data: $('#search').serialize(),
                    success: function(result) {
                        $('#result').html(result);
                    }
                });
            });
        });
    </script>
@endsection
