<button class="btn btn-primary mb-2" onclick="export2csv()">Download csv</button>

<div id="paymenthistory" class="mt-10">
    <div class="table-responsive">
        <table class="table table-bordered " id="tableDownload">
            <tr>
                <th>#</th>
                <th>CID</th>
                <th>Date</th>
                <th>Username</th>
                <th>Name</th>
                <th style="max-width: 150px">Description</th>
                <th>Bill Amount</th>
                <th>Due Amount</th>
                <th>Paid Amount</th>
            </tr>
            @php

                $sum = 0;
            @endphp

            @foreach ($list as $p)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td><a class="btn-info btn-xs text-nowrap clear"
                                href="{{ route('getPaymentHistory', $p->client_id) }}">CID: {{ $p->client_id }}</a></td>

                    <td class="text-center">{{ date('d-M-Y h:i:s A', strtotime($p->created_at)) }}</td>
                    <td>{{ $p->clients->userid ?? '' }}</td>
                    <td>{{ $p->clientsinfo->clients_name ?? '' }}</td>
                    <td>{{ $p->description ?? '' }}</td>

                    @php
                        $adjustment = 0;
                        if($p->due_amount <= 0){
                            $adjustment = $p->bill_amount;
                        }else{
                            $adjustment = $p->bill_amount - $p->due_amount;
                        }
                        $sum += $adjustment;
                    @endphp
                    <td style="text-align: right">{{ $adjustment ?? '' }}</td>
                    <td style="text-align: right">{{ $p->due_amount ?? '' }}</td>
                    <td style="text-align: right">{{ $p->paid_amount ?? '' }}</td>
                </tr>
            @endforeach
            <tr>
                <td style="text-align: right" colspan="6">Total</td>
                <td style="text-align: right"><span style="font-weight:bold;">{{ number_format((float) $sum, 2, '.', '') }}</span></td>
                <td style="text-align: right"><span style="font-weight:bold;">{{ number_format((float) $list->sum('due_amount'), 2, '.', '') }}</span></td>
                <td style="text-align: right"><span style="font-weight:bold;">{{ number_format((float) $list->sum('paid_amount'), 2, '.', '') }}</span></td>
            </tr>
        </table>
    </div>
</div>
<script>
    function export2csv() {
        let data = "";
        const tableData = [];
        const rows = document.querySelectorAll("table#tableDownload tr");
        for (const row of rows) {
            const rowData = [];
            for (const [index, column] of row.querySelectorAll("th, td").entries()) {
                // To retain the commas in the "Description" column, we can enclose those fields in quotation marks.
                if ((index + 1) % 3 === 0) {
                    rowData.push('"' + column.innerText + '"');
                } else {
                    rowData.push(column.innerText);
                }
            }
            tableData.push(rowData.join(","));
        }
        data += tableData.join("\n");
        const a = document.createElement("a");
        a.href = URL.createObjectURL(new Blob([data], {
            type: "text/csv"
        }));
        a.setAttribute("download", "data.csv");
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }
</script>
