@extends('layout.app')

@section('content')
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;"><i class="fa fa-search"></i> Select Criteria
                            </h3>
                        </div>

                        <div class="card-body">

                            <form action="" id="search">
                                <div class="row">
                                    <div class="col-md-2 col-sm-3 col-xs-6">
                                        <div class="form-group">
                                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2"
                                                for="from_date">
                                                Manager Name
                                            </label>
                                            <select name="reseller" id="reseller"
                                                class="form-control select2 form-control-sm" required>
                                                <option value="all" selected>ALL Manager</option>
                                                @foreach (userResellers() as $r)
                                                    <option value="{{ $r->id }}">{{ $r->name }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-sm-3 col-xs-6">
                                        <div class="form-group">
                                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2"
                                                for="from_date">
                                                POP Name
                                            </label>
                                            <select name="pop" id="pop"
                                                class="form-control select2 form-control-sm" required>


                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-2 col-sm-3 col-xs-6">
                                        <div class="form-group">
                                            <label class="flex-1 block text-gray-700 text-sm font-bold mb-2">
                                                Minimum Usage
                                            </label>
                                            <input type="number" name="minimum_usage" id="minimum_usage"
                                                class="form-control form-control-sm">
                                        </div>
                                    </div>

                                    <div class="col-md-12">
                                        <div class="form-group float-right mt-2">

                                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                                    class="fa fa-search"></i> Search</button>
                                            <a href="{{ route('package-upload-download') }}" class="btn btn-info">Reset</a>

                                        </div>
                                    </div>

                                </div>
                            </form>

                            <br>

                            <div id="customer_list_body">
                                {{-- <table class="table" id="dataTableCustome">
                                    <thead class="thead-dark">
                                        <tr>
                                            <th>Package Name</th>
                                            <th>Package Limit</th>
                                            <th>Down Load</th>
                                            <th>Up Load</th>
                                            <th>Total</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($packages_with_upload_download_from_clients as $item)
                                            <tr>
                                                <td>{{ $item->package_name }}</td>
                                                <td>{{ number_format($item->limit_quantity / 1024, 2, '.', '') }} GB </td>
                                                <td>{{ number_format($item->down_load / 1024, 2, '.', '') }} GB </td>
                                                <td>{{ number_format($item->up_load / 1024, 2, '.', '') }} GB </td>
                                                <td>{{ number_format(($item->down_load + $item->up_load) / 1024, 2, '.', '') }}
                                                    GB </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table> --}}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection

@push('js')
    {{-- <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script> --}}

    <script type="text/javascript">
        $(document).ready(function() {
            $('#dataTableCustome').DataTable({
                "searching": true,
                "pageLength": 50,
                "order": [
                    [1, "desc"]
                ]
            });

            $('#searchBtn').on('click', function(e) {
                let package_id = $('#package_id').val();
                let reseller = $('#reseller').val() ?? 'all';
                let pop = $('#pop').val() ?? 'all';
                let minimum_usage = $('#minimum_usage').val();


                e.preventDefault();
                // console.log(package_id);
                $('body').prepend('<div id="loading">Loading.....</div>');


                $.ajax({
                    type: 'get',
                    url: '{{ route('get_all_customer_by_package') }}',
                    data: {
                        package_id: package_id,
                        reseller: reseller,
                        pop: pop,
                        minimum_usage: minimum_usage
                    },
                    success: function(result) {
                        // console.log(result);
                        $('#customer_list_body').html(result);
                        $('#loading').remove();

                        // Update data attributes for server-side DataTable
                        $('#customer_list_body').attr('data-package-id', package_id || '');
                        // Only set reseller/pop if they have values, otherwise leave empty
                        if (reseller && reseller !== 'all') {
                            $('#customer_list_body').attr('data-reseller', reseller);
                        } else {
                            $('#customer_list_body').attr('data-reseller', '');
                        }
                        if (pop && pop !== 'all') {
                            $('#customer_list_body').attr('data-pop', pop);
                        } else {
                            $('#customer_list_body').attr('data-pop', '');
                        }
                        $('#customer_list_body').attr('data-minimum-usage', minimum_usage ||
                            '');
                        // DataTable will auto-initialize via the inline script in clients.blade.php

                    },
                    error: function(error) {
                        toastr.error(error);
                        $('#loading').remove();

                    }
                });
            });


        });
    </script>
@endpush
