@extends('layout.app')


@section('content')

    <div class="card">
        <div class="card-body">
            <a href="{{ route('oltinfo.create') }}" class="btn btn-info mb-4" style="float: right">Add Olt</a>

            <div class="table-responsive">
                <table id="newDataTable" class="display table text-center">
                    <thead class="bg-gray-50">
                        <tr>
                            <th>Olt Address</th>
                            <th>Community</th>
                            <th>Port</th>
                            <th>Olt Company</th>
                            <th>Olt Type</th>
                            <th>Remarks</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @forelse ($oltinfos as $oltinfo)
                            <tr>
                                <td>{{ $oltinfo->olt_address }}</td>
                                <td>{{ $oltinfo->community }}</td>
                                <td>{{ $oltinfo->port }}</td>
                                <td>{{ $oltinfo->olt_company }}</td>
                                <td>{{ $oltinfo->olt_type }}</td>
                                <td>{{ $oltinfo->olt_remarks ?? '' }}</td>
                                <td>
                                    <a href="{{ route('oltinfo.run', $oltinfo->id) }}" class="btn btn-success">Run</a>
                                    <a href="{{ route('oltinfo.edit', $oltinfo->id) }}" class="btn btn-info">Edit</a>
                                    <form action="{{ route('oltinfo.destroy', $oltinfo->id) }}" method="POST"
                                        style="display: inline">
                                        @csrf
                                        @method('DELETE')
                                        <button onclick="return confirm('Are you sure you want to delete?');" class="btn btn-danger" type="submit">Delete</button>
                                    </form>
                                </td>
                            </tr>

                        @empty
                            <tr>
                                <td colspan="6" class="text-center">No Data Found</td>
                            </tr>
                        @endforelse

                    </tbody>
                </table>
            </div>


        </div>
    </div>

@endsection
