@extends('layout.app')


@section('content')
    <div class="card">
        <div class="card-body">
            <h2>Thana List</h2>
            <div class="float-right mb-2">
                <a href="{{ route('location.index') }}" class="btn btn-primary btn-sm">District</a>
                <a href="{{ route('upazilaList') }}" class="btn btn-primary btn-sm">Upazila</a>
            </div>
            <div class="table-responsive">
                <table id="dataTable" class="display">
                    <thead class="bg-gray-50">
                        <tr>
                            <th scope="col" class="text-center">#</th>
                            <th scope="col" class="text-center">Upazila</th>
                            <th scope="col" class="text-center">Thana Name</th>
                            <th scope="col" class="text-center">Thana Name(Bengali)</th>
                            <th scope="col" class="text-center"></th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($thanas as $r)
                            <tr>
                                <td class="text-center">{{ $r->id }}</td>
                                <td class="text-center">{{ $r->upazila->name ?? '' }}</td>
                                <td class="text-center">{{ $r->name }}</td>
                                <td class="text-center">{{ $r->bn_name }}</td>
                                <td class="d-flex">
                                    <a href="{{ route('thanaEdit', $r->id) }}" class="btn btn-primary btn-sm">Edit</a>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection
