@extends('layout.app')

@section('css')
    <link rel="stylesheet" href="{{ asset('admin/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
@endsection

@section('content')
    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title" style="color:#115548;">Line Shift List</h3>
                            <div class="card-tools">
                                <a href="{{ route('line-shift.create') }}"><button class="btn btn-sm btn-primary"><i
                                            class="fa fa-plus-circle" aria-hidden="true"></i> &nbsp; Record</button></a>
                            </div>
                        </div>

                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="dataTable" class="display">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>Username</th>
                                            <th>POP</th>
                                            <th>Old Address</th>
                                            <th>New Address</th>
                                            <th>Shifting Date</th>
                                            <th>Contact</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach ($list as $row)
                                            <tr>
                                                <td>{{ $loop->iteration }}</td>
                                                <td>{{ $row->client->userid ?? '' }}</td>
                                                <td>{{ $row->pops->popname ?? '' }}</td>
                                                <td>{{ $row->old_address }}</td>
                                                <td>Flat No-
                                                    {{ $row->flat_no }}
                                                    , Building No-
                                                    {{ $row->building_no }}
                                                    , Building Name-
                                                    {{ $row->building_name }}
                                                    , Road No-
                                                    {{ $row->road_no }}
                                                    , Road Name-
                                                    {{ $row->road_name }}
                                                    , Block-
                                                    {{ $row->block_sector }}
                                                    , Area-
                                                    {{ $row->area }}
                                                    , Box-
                                                    {{ $row->box }}
                                                    , Lat-
                                                    {{ $row->client_latitude }}
                                                    , Long-
                                                    {{ $row->client_longitude }}
                                                </td>
                                                <td>{{ $row->shifting_date }}</td>
                                                <td>{{ $row->contact }}</td>
                                                <td>{{ $row->status }}</td>
                                                <td>
                                                    {{-- @can('line-shift-edit') --}}
                                                    <div class="btn-group">
                                                        <a href="{{ route('line-shift.edit', $row->id) }}"
                                                            class="btn btn-sm btn-primary">
                                                            <i class="fa fa-edit"></i>

                                                        </a>
                                                    </div>
                                                    {{-- @endcan --}}
                                                    {{-- @can('line-shift-destroy') --}}
                                                    {{-- <div class="btn-group">
                                                        <form action="{{ route('line-shift.destroy', $row) }}"
                                                            method="POST">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button id="{{ $row->id }}"
                                                                class="btn btn-sm btn-danger"><i
                                                                    class="fa fa-trash"></i></button>
                                                        </form>
                                                    </div> --}}
                                                    {{-- @endcan --}}
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection
@section('js')
    <!-- DataTables -->
    <script src="{{ asset('admin/plugins/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('admin/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script>
@endsection
@push('script')
    <!-- page script -->
    <script>
        $(function() {
            $("#example1").DataTable({
                "responsive": true,
                "autoWidth": false,
            });
            $('#example2').DataTable({
                "paging": true,
                "lengthChange": false,
                "searching": false,
                "ordering": true,
                "info": true,
                "autoWidth": false,
                "responsive": true,
            });
        });
    </script>
@endpush
