@extends('layout.app')


@section('content')

    <div class="mt-2 card">
        <div class="card-body">
            <div>
                <a href="{{route('item-return.create')}}" class="btn bg-primary mb-1">Add</a>
            </div>
            <div class="table-responsive">
            <table  class="table table-bordered" id="dataTable">
                <thead>
                    <tr>
                        <th>
                            Id
                        </th>
                        <th class="text-center">
                            Brance
                        </th>
                        <th class="text-center">
                            Employee Name
                        </th>
                        <th class="text-center">Reciver Name</th>
                        <th class="text-center">Total Item</th>
                        <th class="text-center">Date</th>

                        <th class="text-center">
                            Action
                        </th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($itemReturns as $key=>$itemReturn)
                    <tr>
                        <td>{{$itemReturn->id}}</td>
                        <td>{{$itemReturn->branch->name}}</td>
                        <td>{{$itemReturn->employee->name ?? ""}}</td>
                        <td>{{$itemReturn->recivedUser->name}}</td>
                        <td>{{$itemReturn->item->sum('qty')}}</td>
                        <td>{{$itemReturn->date}}</td>
                        <td>
                            <div>
                                @if (isset($itemReturn->employee))

                                    <a href="{{ route('item-return.edit', $itemReturn->id) }}">
                                        <button class="btn btn-info ml-2">Edit</button>
                                    </a>
                                @endif
                            </div>
                        </td>
                    </tr>

                    @endforeach

                </tbody>
            </table>
            </div>


        </div>
    </div>





@endsection
