@can('dashboard-billing-info')
    @if (checkSettings('reseller_bill_collection') == 'enable')
        <section class="bill-collection-area bg-white pt-2  mt-2 mb-2 pb-2">
            <h4 class="text-center my-2">Monthly Bill Collection [Only Other] Manager Reports
                {{ date('M') }} {{ date('Y') }}</h4>
            <table class="table table-hover table-responsive-lg">
                <thead>
                    <tr>
                        <th scope="col" class="h6">Manager Name</th>
                        <th scope="col" class="h6 text-right">Approximate Monthly Bill</th>
                        <th scope="col" class="h6 text-right">Previous Month Bill Collection</th>
                        <th scope="col" class="h6 text-right">This Month Bill Collection</th>
                        <th scope="col" class="h6 text-right">Collection(%)</th>
                        <th scope="col" class="h6 text-right">This Month Due</th>
                    </tr>
                </thead>
                <tbody>
                    @php

                        $this_month_bill = 0;
                        $previous_month_collection = 0;
                        $this_month_collection = 0;
                    @endphp

                    @foreach ($resellerWiseOtherReport as $item)
                        @php
                            $bill = 0;

                            foreach ($item as $r) {
                                $bill += $r->total_client * $r->package_rate;
                            }
                        @endphp
                        <tr>
                            <td class="h6">
                                {{ $item->first()->name }}
                            </td>
                            <td class="text-right">{{ $bill }}</td>
                            <td class="text-right">{{ $item->previous_monthly_bill_collection }}</td>
                            <td class="text-right">{{ $item->monthly_bill_collection }}</td>
                            <td class="text-right">
                                @if($bill !=0 && $item->monthly_bill_collection != 0)
                                    {{ round(($item->monthly_bill_collection * 100) / $bill, 2) }} %
                                @endif
                            </td>
                            <td class="text-right">{{ $bill - $item->monthly_bill_collection }}</td>
                        </tr>

                        @php
                            $this_month_bill += $bill;
                            $previous_month_collection += $item->previous_monthly_bill_collection;
                            $this_month_collection += $item->monthly_bill_collection;
                        @endphp
                    @endforeach

                    <tr class="bg-gray">
                        <td class="h6">Total</td>
                        <td class="h6 text-right">{{ $this_month_bill }}</td>
                        <td class="h6 text-right">{{ $previous_month_collection }}</td>
                        <td class="h6 text-right">{{ $this_month_collection }}</td>
                        <td class="h6 text-right">
                            @if ($this_month_bill != 0)
                                {{ round(($this_month_collection * 100) / $this_month_bill, 2) }} %
                            @else
                                0 %
                            @endif
                        </td>
                        <td class="h6 text-right">{{ $this_month_bill - $this_month_collection }}</td>
                    </tr>
                </tbody>
            </table>
        </section>
    @endif
@endcan
