@props(['mikroticInfo'])

<div class="modal fade " id="edit-mikrotik-{{ $mikroticInfo->id }}" tabindex="-1" role="dialog"
    aria-labelledby="exampleModalLabel" aria-hidden="true">

    <div class="modal-dialog modal-dialog-centered " role="document">
        <div class="modal-content p-3">
            <div class="modal-header border-bottom-0">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true" class="text-danger">&times;</span>

                </button>

            </div>
            <div class="border p-1 text-center rounded" style="width: 95% !important; margin:auto !important">
                <h4>Edit Mikrotik Information {{ $mikroticInfo->id }}</h1>
            </div>
            <form action="{{ route('mikrotiks.store') }}" method="POST">
                @csrf
                <div class="modal-body">
                    <div class="d-flex justify-content-between mobile-column" style="gap:2px;">
                        <div class="form-group" style="width: 48%;">
                            <label for="mikrotik name">Mikrotik Name <span class="text-danger"
                                    style="font-size: 1.25rem; display:inline-block;">*</span> </label>
                            <input type="text" name="shortname" class="form-control" id="shortname"
                                value="{{ $mikroticInfo->shortname }}" placeholder="Mikrotik Name">

                            @error('shortname')
                                <small class="form-text  text-danger">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="form-group" style="width: 48%;">
                            <label for="mikrotikip">Mikrotik IP <span class="text-danger"
                                    style="font-size: 1.25rem; display:inline-block;">*</span> </label>
                            <input type="text" name="nasname" class="form-control" placeholder="Mikrotik IP"
                                value="{{ $mikroticInfo->nasname }}" autocomplete="off">
                            @error('nasname')
                                <small class="form-text  text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>

                    @if (!checkAPI())
                        <div class="form-group">
                            <label for="secret" class="">
                                Secret*
                            </label>
                            <input type="text" name="secret" id="secret" class="form-control"
                                placeholder="Mikrotik Radius Secret" value="{{ old('secret') }}" autocomplete="off"
                                required>
                            @error('secret')
                                <small class="form-text text-danger">
                                    {{ $message }}
                                </small>
                            @enderror
                        </div>
                    @endif

                    <div class="form-group">
                        <label for="username">Mikrotik User Name </label>
                        <input type="text" name="mickrotik_user_name" class="form-control" id="email1"
                            placeholder="Mikrotik Username">
                        @error('mickrotik_user_name')
                            <small class="form-text  text-danger">{{ $message }}</small>
                        @enderror
                    </div>


                    <div class="d-flex flex-row-reverse justify-content-between mobile-column">
                        <div class="form-group " style="width: 48%;">
                            <label for="mikrotik port">Mikrotik Port</label>
                            <input type="text" name="mickrotik_port" value="{{ $mikroticInfo->mikrotick_port }}"
                                class="form-control border rounded border-primary" placeholder="Mikrotik Port">
                            @error('mickrotik_port')
                                <small class="form-text  text-danger">{{ $message }}</small>
                            @enderror
                        </div>

                        <div class="form-group " style="width: 48%;">
                            <label for="password">Password</label>
                            <input type="text" name="mickrotik_user_password"
                                value="{{ $mikroticInfo->mikrotick_user_password }}" class="form-control"
                                id="password1" placeholder="Password">
                            @error('mickrotik_user_password')
                                <small class="form-text  text-danger">{{ $message }}</small>
                            @enderror
                        </div>
                    </div>

                    <div class="form-group">
                        <label for="password1">Description <span class="text-danger"
                                style="font-size: 1.25rem; display:inline-block;">*</span> </label>
                        <textarea class="form-control" name="description" id="" cols="3" rows="2">{{ $mikroticInfo->description }}</textarea>
                        @error('description')
                            <small class="form-text  text-danger">{{ $message }}</small>
                        @enderror
                    </div>

                    @if (checkSettings('static_ip_manage') == 'enable')
                        <div class="form-group">


                            <button type="button" class=" btn btn-color" id="static_ip_button">Add Static Ip
                            </button>


                            <div class="w-100 p-2 border rounded mt-2 d-none" id="staticIpContainer"
                                style="height: 160px; overflow-y: auto;">
                                <ul class="list-group" id="staticIpList">

                                </ul>
                            </div>

                        </div>
                    @endif
                </div>
                <div class="modal-footer border-top-0 d-flex justify-content-center">
                    <button type="submit" class="btn btn-submit w-100">Submit</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
    const staticIpCreator = document.getElementById("static_ip_button");
    const staticIpContainer = document.getElementById("staticIpContainer");
    const staticIpList = document.getElementById("staticIpList");

    staticIpCreator.addEventListener("click", function() {
        if (staticIpContainer.classList.contains('d-none')) {
            staticIpContainer.classList.remove('d-none');
            staticIpContainer.classList.add("d-block");
            staticIpCreator.textContent = "Add More";
        }

        const newListItem = document.createElement('li');
        newListItem.className = "list-group-item d-flex justify-content-between";
        newListItem.style.gap = "2px";

        newListItem.innerHTML = `
            <input type="text" name="port[]" class="form-control" placeholder="port" required>
            <input type="text" name="ip_block[]" class="form-control" placeholder="Ip Block" required>
            <button class="text-danger p-1 border rounded delete-button">X</button>`;

        const deleteButton = newListItem.querySelector('.delete-button');

        deleteButton.addEventListener('click', function() {
            staticIpList.removeChild(newListItem);
            if (staticIpList.children.length <= 3) {
                staticIpList.classList.remove("scrollable-list");
            }
            if (staticIpList.children.length === 0) {
                staticIpContainer.classList.remove("d-block");
                staticIpContainer.classList.add('d-none');
                staticIpCreator.textContent = "Add Static Ip";
            }
        });
        staticIpList.appendChild(newListItem);

    });
</script>


@push('styles')
    <link rel="stylesheet" href="{{ asset('css/mikrotik/editmikrotik.css') }}">
@endpush
