<div :class="{ 'flex': open, 'hidden': !open }"
    class="right-nav flex-col flex-grow {{ $mobile ?? 'hidden' }} pb-4 md:pb-0 md:flex md:justify-end md:flex-row bg-danger">
    <div @click.away="open = false" class="relative" x-data="{ open: false }">
        <button @click="open = !open"
            class="flex flex-row text-white  items-center w-full px-4 py-2 mt-2 text-sm font-semibold text-left bg-transparent rounded-lg dark-mode:bg-transparent dark-mode:focus:text-white dark-mode:hover:text-white dark-mode:focus:bg-gray-600 dark-mode:hover:bg-gray-600 md:w-auto md:inline md:mt-0 md:ml-4 hover:text-gray-900 focus:text-gray-900 hover:bg-gray-200 focus:bg-gray-200 focus:outline-none focus:shadow-outline">
            <span> <i class="fa fa-{{ $iconName }}"></i> {{ $navTitle }}</span>
            <svg fill="currentColor" viewBox="0 0 20 20" :class="{ 'rotate-180': open, 'rotate-0': !open }"
                class="inline w-4 h-4 mt-1 ml-1 transition-transform duration-200 transform md:-mt-1">
                <path fill-rule="evenodd"
                    d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z"
                    clip-rule="evenodd"></path>
            </svg>
        </button>
        <div x-show="open" class="absolute right-0  mt-2 origin-top-right z-50">

            <div class="px-2 pt-2 pb-4 bg-white rounded-md shadow-lg dark-mode:bg-gray-700">
                <div class="dropdown-item" style="width:300px">

                    {{ $slot }}

                </div>
            </div>
        </div>
    </div>
</div>
