@extends('layout.app')
@section('content')

<div class="card" id="bodyBox">
    <div class="card-body">


                    <a class="btn btn-primary"
                        href="{{ route('printExpiredClients') }}?type={{request()->type}}" target="blank"><i
                            class="fa fa-print"></i> Print
                    </a>
                    
                    <div class="float-right">
                        <select name="pop" id="pop" class="select2 form-control" style="height:50px">
                            <option value="">Select Pop/Zone</option>
                            <option value="all">All Pop/Zone</option>

                            @foreach($poplist as $pop)
                            <option value="{{$pop->id}}">{{ $pop->popname }}</option>
                            @endforeach
                        </select>
                    </div>
                    
                    
                    @if(request()->type !='all')

                    @foreach($poplist as $pop)
                    @if($pop->id == request()->type)
                    <h2 class="text-center bold text-xl font-bold pb-5 mt-5 pop{{$pop->id}}">View Customer Billing
                        Information Of: {{$pop->popname}} ( {{ date('M-Y') }} )
                    </h2>
                    @endif
                    @endforeach
                    <hr>
                    <div class="table-responsive">
                    <table id="dataTable" class="table table-bordered  pop{{$pop->id}}">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col"
                                    >
                                    ID
                                </th>
                                <th scope="col"
                                    >
                                    User name
                                </th>
                                <th scope="col"
                                    >
                                    Password
                                </th>
                                <th scope="col"
                                    >
                                    Status
                                </th>
                                <th scope="col"
                                    >
                                    Expire
                                </th>
                                <th scope="col"
                                    >
                                    Bill Cycle
                                </th>
                                <th scope="col"
                                    >
                                    Bill Amount
                                </th>
                                <th scope="col"
                                    >
                                    OTC
                                </th>
                                <th scope="col"
                                    >
                                    Package
                                </th>
                                <th scope="col"
                                    >
                                    POP
                                </th>
                                <th scope="col"
                                    >
                                    Name
                                </th>
                                <th scope="col"
                                    >
                                    Address
                                </th>
                                <th scope="col"
                                    >
                                    Contact
                                </th>
                                <th scope="col"
                                    >
                                    Created Date
                                </th>
                                <th scope="col"
                                    >
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach ($list as $r)
                            {{-- {{dd($r)}} --}}
                            <tr @if($r->clients_status == 'deactive') class="deactive" @endif>
                                <td>
                                    <a class="underline text-blue-300"
                                        href="{{route('getPaymentHistory',$r->id)}}">@php(printf("CID%04d",$r->id))</a>
                                    <a href="{{route('getCustomerLogHistory',$r->userid)}}"
                                        class="noprint btn btn-primary btn-xs btn-block">Log
                                    </a>
                                </td>
                                <td>
                                    {{$r->userid}}
                                </td>
                                <td class="noprint">
                                    {{$r->password}}
                                </td>
                                <td @if($r->clients_status == 'expired') class="deactive" @endif>
                                    @if($r->client_approval == 'pending')
                                    {{ $r->client_approval }}
                                    @else
                                    <x-Custom.Status status="{{ $r->clients_status }}" />
                                    @endif
                                </td>
                                <td class="whitespace-nowrap">
                                    {{ date('d-M-Y',strtotime($r->expire_date)) }}
                                </td>
                                <td>
                                    {{$r->billing_cycle}}
                                </td>
                                <td>
                                    {{$r->package_rate}}
                                </td>
                                <td>
                                    {{-- {{$r->otc}} --}}
                                </td>
                                <td>
                                    {{$r->package_name}}
                                </td>
                                <td>
                                    {{ $r->popname ?? '' }}
                                </td>
                                <td>
                                    {{ $r->clients_name ?? ''}}
                                </td>
                                <td style="max-width:250px;">
                                    <p style="font-size:12px;">Flat No: {{$r->flat_no ?? ''}} ,
                                        Building Name: {{ $r->building_name ?? ''}} ,<br>
                                        Road No: {{ $r->road_no ?? '' }} ,<br>
                                        Block/Sector: {{ $r->block_sector ?? '' }} ,
                                        Area : {{ $r->area ?? '' }} </p>
                                </td>
                                <td>
                                    {{$r->contact_no ?? ''}}
                                </td>
                                <td class="whitespace-nowrap">
                                    {{ date('d-M-Y',strtotime($r->created_at)) }}
                                </td>
                                <td class="px-6 text-center text-sm font-medium noprint">
                                    <x-Custom.Btn url="{{route('clients.show',$r->id)}}"
                                        class="inline-block btn-green text-xs" value="Details" />
                                    @can('mac-customer_edit')
                                    <x-Custom.Btn url="{{route('clients.edit',$r->id)}}"
                                        class="inline-block btn-blue text-xs" value="Edit" />
                                    @endcan
                                    @if($r->client_approval == 'pending')
                                    @can('new-customer-approve')
                                    <x-Custom.Actionform href="{{ route('clinetApprove',$r->id) }}" formClass="approve"
                                        btnClass="inline-block text-xs bg-green-600 text-white" submitValue="Approve"
                                        inputName="user_approve" inputId="{{$r->id}}" />
                                    @endcan
                                    @endif
                                    @if($r->clients_status == 'disable')
                                    @can('id-enable')
                                    <a href="{{route('idEnable',$r->id)}}"
                                        onclick="return confirm('Are you sure you want to Enable the ID?');"
                                        class="inline-flex text-xs justify-center py-1 text-white px-2 mt-2 border border-transparent shadow-sm font-medium rounded-sm block bg-green-600 hover:bg-green-900">Enable</a>
                                    @endcan
                                    @endif
                                    @if($r->clients_status == 'active')
                                    @can('id-disable')
                                    <a href="{{route('idDisable',$r->id)}}"
                                        onclick="return confirm('Are you sure you want to Disable the ID?');"
                                        class="confirmDisable inline-flex text-xs justify-center py-1 text-white px-2 mt-2 border border-transparent shadow-sm font-small rounded-sm block bg-yellow-600 hover:bg-red-900">Disable</a>
                                    @endcan
                                    @endif
                                    @role('Admin')
                                    <form method="POST" action="{{route('clients.destroy',$r->id)}}">
                                        @method('DELETE')
                                        @csrf
                                        <button
                                            onclick="return confirm('Are you sure you want to Perform the Action?');"
                                            type="submit"
                                            class="cursor-pointer mt-2 uppercase px-2 py-1 rounded shadow-sm hover:shadow-lg inline-block bg-red-600 text-xs text-white">Delete</button>
                                    </form>
                                    @endrole
                                    @can('customer-recharge')
                                    @if($r->clients_status == 'active')
                                    @endif
                                    @if($r->clients_status == 'expired')
                                    <x-Custom.Actionform href="{{ route('recharge',$r->id) }}" formClass="approve"
                                        btnClass="block bg-yellow-400 text-white" submitValue="Recharge 1 Month"
                                        inputName="recharge" inputId="{{$r->id}}" />
                                    @endif
                                    @endcan
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    </div>

                    {{-- @endif --}}
                    @else

                    {{-- @if(request()->type !='all') --}}

                    @foreach($poplist as $pop)
                    <h2 class="text-center bold text-xl font-bold pb-5 mt-5 pop{{$pop->id}}">View Customer Billing
                        Information Of: {{$pop->popname}} ( {{ date('M-Y') }} )
                    </h2>

                    <hr>
                    <table id="dataTable" class="table table-bordered pop{{$pop->id}}">
                        <thead class="bg-gray-50">
                            <tr>
                                <th scope="col"
                                    >
                                    ID
                                </th>
                                <th scope="col"
                                    >
                                    User name
                                </th>
                                <th scope="col"
                                    >
                                    Password
                                </th>
                                <th scope="col"
                                    >
                                    Status
                                </th>
                                <th scope="col"
                                    >
                                    Expire
                                </th>
                                <th scope="col"
                                    >
                                    Bill Cycle
                                </th>
                                <th scope="col"
                                    >
                                    Bill Amount
                                </th>
                                <th scope="col"
                                    >
                                    OTC
                                </th>
                                <th scope="col"
                                    >
                                    Package
                                </th>
                                <th scope="col"
                                    >
                                    POP
                                </th>
                                <th scope="col"
                                    >
                                    Name
                                </th>
                                <th scope="col"
                                    >
                                    Address
                                </th>
                                <th scope="col"
                                    >
                                    Contact
                                </th>
                                <th scope="col"
                                    >
                                    Created Date
                                </th>
                                <th scope="col"
                                  >
                                </th>
                            </tr>
                        </thead>
                        <tbody class="bg-white divide-y divide-gray-200">
                            @foreach ($list as $r)
                            {{-- {{dd($r)}} --}}
                            @if($r->pop_id == $pop->id)
                            <tr @if($r->clients_status == 'deactive') class="deactive" @endif>
                                <td>
                                    <a class="underline text-blue-300"
                                        href="{{route('getPaymentHistory',$r->id)}}">@php(printf("CID%04d",$r->id))</a>

                                    <a href="{{route('getCustomerLogHistory',$r->userid)}}"
                                        class="btn btn-primary btn-block btn-xs">Log</a>
                                </td>
                                <td>
                                    {{$r->userid}}
                                </td>
                                <td class="noprint">
                                    {{$r->password}}
                                </td>
                                <td @if($r->clients_status == 'expired') class="deactive" @endif>
                                    @if($r->client_approval == 'pending')
                                    {{ $r->client_approval }}
                                    @else
                                    <x-Custom.Status status="{{ $r->clients_status }}" />
                                    @endif
                                </td>
                                <td class="whitespace-nowrap">
                                    {{ date('d-M-Y',strtotime($r->expire_date)) }}
                                </td>
                                <td>
                                    {{$r->billing_cycle}}
                                </td>
                                <td>
                                    {{$r->package_rate}}
                                </td>
                                <td>
                                    {{-- {{$r->otc}} --}}
                                </td>
                                <td>
                                    {{$r->package_name}}
                                </td>
                                <td>
                                    {{ $r->popname ?? '' }}
                                </td>
                                <td>
                                    {{ $r->clients_name ?? ''}}
                                </td>
                                <td style="max-width:250px;">
                                    <p style="font-size:12px;">Flat No: {{$r->flat_no ?? ''}} ,
                                        Building Name: {{ $r->building_name ?? ''}} ,<br>
                                        Road No: {{ $r->road_no ?? '' }} ,<br>
                                        Block/Sector: {{ $r->block_sector ?? '' }} ,
                                        Area : {{ $r->area ?? '' }} </p>
                                </td>
                                <td>
                                    {{$r->contact_no ?? ''}}
                                </td>
                                <td class="whitespace-nowrap">
                                    {{ date('d-M-Y',strtotime($r->created_at)) }}
                                </td>
                                <td class="px-6 text-center text-sm font-medium noprint">
                                    <x-Custom.Btn url="{{route('clients.show',$r->id)}}"
                                        class="inline-block btn-green text-xs" value="Details" />
                                    @can('mac-customer_edit')
                                    <x-Custom.Btn url="{{route('clients.edit',$r->id)}}"
                                        class="inline-block btn-blue text-xs" value="Edit" />
                                    @endcan
                                    @if($r->client_approval == 'pending')
                                    @can('new-customer-approve')
                                    <x-Custom.Actionform href="{{ route('clinetApprove',$r->id) }}" formClass="approve"
                                        btnClass="inline-block text-xs bg-green-600 text-white" submitValue="Approve"
                                        inputName="user_approve" inputId="{{$r->id}}" />
                                    @endcan
                                    @endif
                                    @if($r->clients_status == 'disable')
                                    @can('id-enable')
                                    <a href="{{route('idEnable',$r->id)}}"
                                        onclick="return confirm('Are you sure you want to Enable the ID?');"
                                        class="inline-flex text-xs justify-center py-1 text-white px-2 mt-2 border border-transparent shadow-sm font-medium rounded-sm block bg-green-600 hover:bg-green-900">Enable</a>

                                    @endcan
                                    @endif
                                    @if($r->clients_status == 'active')
                                    @can('id-disable')
                                    <a href="{{route('idDisable',$r->id)}}"
                                        onclick="return confirm('Are you sure you want to Disable the ID?');"
                                        class="confirmDisable inline-flex text-xs justify-center py-1 text-white px-2 mt-2 border border-transparent shadow-sm font-small rounded-sm block bg-yellow-600 hover:bg-red-900">Disable</a>

                                    @endcan
                                    @endif
                                    @role('Admin')
                                    <form method="POST" action="{{route('clients.destroy',$r->id)}}">
                                        @method('DELETE')
                                        @csrf
                                        <button
                                            onclick="return confirm('Are you sure you want to Perform the Action?');"
                                            type="submit"
                                            class="cursor-pointer mt-2 uppercase px-2 py-1 rounded shadow-sm hover:shadow-lg inline-block bg-red-600 text-xs text-white">Delete</button>
                                    </form>
                                    @endrole
                                    @can('customer-recharge')
                                    @if($r->clients_status == 'active')
                                    @endif
                                    @if($r->clients_status == 'expired')
                                    <x-Custom.Actionform href="{{ route('recharge',$r->id) }}" formClass="approve"
                                        btnClass="block bg-yellow-400 text-white" submitValue="Recharge 1 Month"
                                        inputName="recharge" inputId="{{$r->id}}" />
                                    @endif
                                    @endcan
                                </td>
                            </tr>
                            @endif
                            @endforeach
                        </tbody>
                    </table>

                    @endforeach
                    @endif


                    <div class="p-5">
                        @if(isset($paginate) && $paginate !== false ))
                        {{  $list->links()  }}
                        @endif
                    </div>
    </div>
</div>

<style>
    @media print {
        a {
            text-decoration: none !important;
            color: #222 !important;
        }

        th {
            font-size: 10px !important;
            padding: 2px !important;
            text-align: center;
        }

        tr {
            font-size: 10px !important;
            margin: 2px !important;
            padding: 2px !important;
        }

        td {
            font-size: 10px !important;
            margin: 2px !important;
            padding: 2px !important;
        }

        table {
            width: 100%;
        }

        .shadow {
            box-shadow: none;
        }

        tr th:last-child {
            display: none !important;
        }

        tr td:last-child {
            display: none !important;
        }

    }
</style>


@endsection

{{-- @section('ajax')
<script type="text/javascript">
</script>


@endsection --}}

@section('ajax')
<script type="text/javascript">
    $(document).ready( function () {
    $('#pop').on('change',function(){
        var type = $("#pop").val();
        window.location.href = "{{route('expiredClients')}}"+"?type="+type;
    });
    } );
</script>




{{-- <script type="text/javascript">
    window.onload = function() { window.print(); }
    window.onfocus=function(){ window.close(); }
</script> --}}



@endsection