@extends('layout.app')
@section('content')
    <div class="container">
        <!-- Import Results Section -->
        @if (session('showResults'))
            <div class="card mb-4">
                <div class="card-header {{ session('wasRolledBack') ? 'bg-danger text-white' : 'bg-warning text-dark' }}">
                    <h5 class="mb-0">
                        <i class="fas fa-exclamation-triangle"></i>
                        Import Results
                    </h5>
                </div>
                <div class="card-body">
                    @if (session('wasRolledBack'))
                        <div class="alert alert-danger">

                            <p class="mb-0">Due to errors in the import file, the entire import was cancelled and
                                <strong>NO records were saved</strong>. Please fix all errors and try again.
                            </p>
                        </div>
                    @endif

                    <div class="row mb-3">
                        <div class="col-md-6">
                            <div class="alert {{ session('wasRolledBack') ? 'alert-secondary' : 'alert-success' }}">
                                <strong>Successfully Imported:</strong> {{ session('successCount', 0) }} records

                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="alert alert-danger">
                                <strong>Errors Found:</strong> {{ count(session('importErrors', [])) }} issues
                            </div>
                        </div>
                    </div>

                    @if (!empty(session('importErrors')))
                        <div class="alert alert-warning">
                            <h6><i class="fas fa-list"></i> Error Details:</h6>
                            <div
                                style="max-height: 400px; overflow-y: auto; border: 1px solid #ddd; padding: 15px; background-color: #f8f9fa; border-radius: 5px;">
                                <ul class="mb-0" style="padding-left: 20px;">
                                    @foreach (session('importErrors', []) as $error)
                                        <li style="margin-bottom: 8px; font-size: 14px;">{{ $error }}</li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>

                        <div class="mt-3">
                            <p class="text-muted">
                                <i class="fas fa-info-circle"></i>
                                @if (session('wasRolledBack'))
                                    Please fix ALL errors in your Excel file and try importing again. The import uses an
                                    "all or nothing" approach - if any row has errors, no records will be saved.
                                @else
                                    Please fix the errors in your Excel file and try importing again. Only the rows with
                                    errors were skipped.
                                @endif
                            </p>
                        </div>
                    @endif


                </div>
            </div>
        @endif

        <div class="card ">
            <div class="card-body ">
                <form action="{{ route('store-client-import-to-customer') }}" method="POST"
                    class="flex flex-wrap  border  rounded p-3" enctype="multipart/form-data" class="border-color:#9ca3af;">
                    @csrf

                    <div class="row" style="width: 60%; margin:auto !important;">
                        <div class="col-md-12 text-start">
                            <h4 class="">Customer Import From Excel</h4>
                            <hr>
                            <p style="font-size: 16px !important">1<sup>st</sup> Download The Excel File. Fillup the column
                                carefully. Where(
                                <span class="text-danger">*</span> )
                                Marked Column is Mandatory
                            </p>

                            <p class="mt-3" style="font-size: 16px !important; font-weight:400">Please do not delete first

                                row or header row.</p>
                        </div>
                        <div class="col-md-12 mb-2">
                            <a class="btn btn-success d-block" href="{{ route('clientImportSampleDownload') }}">Download
                                Customer
                                Import Sample Excel</a>
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <input type="file" class="form-control" id="code" placeholder="Select Excle File"
                                    style="height: 43px;" name="clientFile" autocomplete="off" required>
                            </div>
                        </div>
                        <hr>

                        <div class="col-md-12">
                            <button class="btn form-control btn-primary " style="hight: 10px" type="submit"
                                id="submitButton">Submit
                            </button>
                        </div>
                    </div>

                </form>
            </div>
        </div>


        @can('client-due-import-to-customer')
            <div class="card mt-2">
                <div class="card-body ">
                    <form action="{{ route('storeClientDueImportToCustomer') }}" method="POST"
                        class="flex flex-wrap  border  rounded p-3" enctype="multipart/form-data" class="border-color:#9ca3af;">
                        @csrf

                        <div class="row" style="width: 60%; margin:auto !important;">
                            <div class="col-md-12 text-start">
                                <h4 class="">Customer Due Import From Excel</h4>
                                <hr>
                                <p style="font-size: 16px !important">1<sup>st</sup> Download The Excel File. Fillup the column
                                    carefully. Where(
                                    <span class="text-danger">*</span> )
                                    Marked Column is Mandatory
                                </p>

                                <p class="mt-3" style="font-size: 16px !important; font-weight:400">Please do not delete first

                                    row or header row.</p>
                            </div>
                            <div class="col-md-12 mb-2">
                                <a class="btn btn-success d-block" href="{{ route('clientDueImportSampleDownload') }}">Download
                                    Customer due
                                    Import Sample Excel</a>
                            </div>

                            <div class="col-md-12">
                                <div class="form-group">
                                    <input type="file" class="form-control" id="code" placeholder="Select Excle File"
                                        style="height: 43px;" name="clientDueFile" autocomplete="off" required>
                                </div>
                            </div>
                            <hr>

                            <div class="col-md-12">
                                <button class="btn form-control btn-primary " style="hight: 10px" type="submit"
                                    id="submitButton">Submit
                                </button>
                            </div>
                        </div>

                    </form>
                </div>
            </div>
        @endcan


        <div class="mt-2 card">

        </div>
    </div>
@endsection
