@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-body">
            <a href="{{ route('client-source.create') }}" type="button" class="btn btn-primary float-right">
                Add New Source
            </a>
        </div>

        <div class="card-body">
            <div class="table-responsive">
                <table id="dataTablea" class="table">
                    <thead class="bg-gray-50">
                        <tr>
                            <th>Id</th>
                            <th>Name</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white divide-y divide-gray-200">
                        @foreach ($sources as $source)
                            <tr>
                                <td>{{ $source->id }}</td>
                                <td>{{ $source->name }}</td>
                                <td>
                                    <a href="{{ route('client-source.edit', $source->id) }}" class="btn btn-sm btn-primary">
                                        Edit
                                    </a>
                                    <a href="{{ route('editLog-history', ['id' => $source->id, 'type' => 'Client Source']) }}" target="_blank" class="btn btn-sm btn-secondary">
                                        History
                                    </a>
                                    {{-- <form action="{{ route('client-source.destroy', $source->id) }}" method="POST"
                                          style="display:inline-block"
                                          onsubmit="return confirm('Are you sure you want to delete this client source?');">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger">
                                            Delete
                                        </button>
                                    </form> --}}
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
@endsection

