@extends('layout.app')

@section('content')
    <div class="row mb-3">
        <div class="col-md-3">
            <input type="date" id="from_date" class="form-control">
        </div>
        <div class="col-md-3">
            <input type="date" id="to_date" class="form-control">
        </div>
        <div class="col-md-3">
            <button id="filter" class="btn btn-primary">Search</button>
            <button id="reset" class="btn btn-secondary">Reset</button>
        </div>
    </div>

    <div class="table-responsive">
        <table id="dataTable" class="table table-bordered table-striped">
            <thead class="bg-dark text-white">
                <tr>
                    <th>Payment Number</th>
                    <th>Amount</th>
                    <th>TrxID</th>
                    <th>Reference</th>
                    <th>Date Time</th>
                </tr>
            </thead>
        </table>
    </div>
@endsection

@section('ajax')
    <script>
        $(document).ready(function() {

            if ($.fn.DataTable.isDataTable('#dataTable')) {
                $('#dataTable').DataTable().clear().destroy();
            }

            let table = $('#dataTable').DataTable({
                processing: true,
                serverSide: true,
                destroy: true,
                pageLength: 100, // ✅ SHOW 100 ROWS
                lengthMenu: [ // ✅ OPTIONS
                    [10, 25, 50, 100, 200, 500],
                    [10, 25, 50, 100, 200, 500]
                ],
                ajax: {
                    url: '{{ route('bkashWebhookReport.datatable') }}',
                    data: function(d) {
                        d.from_date = $('#from_date').val();
                        d.to_date = $('#to_date').val();
                    }
                },
                columns: [{
                        data: 'payment_number',
                        name: 'payment_number'
                    },
                    {
                        data: 'amount',
                        name: 'amount'
                    },
                    {
                        data: 'trxid',
                        name: 'trxid'
                    },
                    {
                        data: 'reference',
                        name: 'reference'
                    },
                    {
                        data: 'date_time',
                        name: 'date_time'
                    },
                ],
                order: [
                    [4, 'desc']
                ]
            });

            $('#filter').on('click', function() {
                table.draw();
            });

            $('#reset').on('click', function() {
                $('#from_date').val('');
                $('#to_date').val('');
                table.draw();
            });

        });
    </script>
@endsection
