<button class="btn btn-primary mb-2" onclick="export2csv()">Download csv</button>

<div id="paymenthistory" class="mt-10">
    <div class="table-responsive">
        <table class="table table-bordered table-striped" id="tableDownload">
            <thead>
                <tr>
                    <th>#</th>
                    <th>CID</th>
                    <th>Username</th>
                    <th>Name</th>
                    <th>POP</th>
                    @if ($type != 'Zero Payment')
                        <th style="min-width: 150px">Total Bill</th>
                        <th style="min-width: 150px">paid Bill</th>
                        <th style="min-width: 150px">discount Bill</th>
                    @endif
                </tr>
            </thead>
            @php
                $from = \Carbon\Carbon::parse(request()->from_date)->format('Y-m-d 00:00:00');
                $to = \Carbon\Carbon::parse(request()->to_date)->format('Y-m-d 23:59:59');
                $totalBill = 0;
                $totalPayment = 0;
                $totalDiscount = 0;
                $sl = 1;
            @endphp
            <tbody>
                {{-- dd($list) --}}
                @foreach ($list as $row)
                    @if ($type == 'Zero Payment')
                        {{-- @if ($row->total_paid_amount == 0) --}}
                            <tr>
                                <td>{{ $sl }}</td>
                                <td>
                                    <a class="btn-info btn-xs text-nowrap clear"
                                        href="{{ route('getPaymentHistory', $row->id) }}">CID:
                                        {{ $row->id }}</a>
                                </td>
                                <td>{{ $row->userid ?? '' }}</td>
                                <td>{{ $row->clientsinfo->clients_name ?? '' }}</td>
                                <td>{{ $row->pop->popname ?? '' }}</td>
                                {{-- <td class="text-right">
                                    {{ number_format((float) $row->customerAccount->dueAmount, 2, '.', '') }}
                                </td> --}}
                            </tr>
                            @php
                                $sl += 1;
                            @endphp
                        {{-- @endif --}}
                    @else
                        <tr>
                            <td>{{ $loop->iteration }}</td>
                            <td>
                                <a class="btn-info btn-xs text-nowrap clear"
                                    href="{{ route('getPaymentHistory', $row->id) }}">CID:
                                    {{ $row->id }}</a>
                            </td>
                            <td>{{ $row->userid ?? '' }}</td>
                            <td>{{ $row->clientsinfo->clients_name ?? '' }}</td>
                            <td>{{ $row->pop->popname ?? '' }}</td>
                            <td class="text-right">
                                @php
                                    $bill = 0;
                                @endphp
                                @foreach ($row->generatedBill as $item)
                                    @if ($item->created_at >= $from && $item->created_at <= $to)
                                        @php
                                            $bill += $item->bill_amount ?? 0;
                                        @endphp
                                    @endif
                                @endforeach
                                {{ number_format((float) $bill, 2, '.', '') }}
                            </td>
                            <td class="text-right">
                                @php
                                    $payment = 0;
                                @endphp
                                @foreach ($row->paymentBill as $item)
                                    @if ($item->created_at >= $from && $item->created_at <= $to)
                                        @php
                                            $payment += $item->paid_amount ?? 0;
                                        @endphp
                                    @endif
                                @endforeach
                                {{ number_format((float) $payment, 2, '.', '') }}
                            </td>
                            <td class="text-right">
                                @php
                                    $discount = 0;
                                @endphp
                                @foreach ($row->paymentBill as $item)
                                    @if ($item->created_at >= $from && $item->created_at <= $to)
                                        @php
                                            $discount += $item->discount_amount ?? 0;
                                        @endphp
                                    @endif
                                @endforeach
                                {{ number_format((float) $discount, 2, '.', '') }}
                            </td>
                        </tr>
                        @php
                            $totalBill += $bill;
                            $totalPayment += $payment;
                            $totalDiscount += $discount;
                        @endphp
                    @endif
                @endforeach
                @if ($type != 'Zero Payment')
                    <tr>
                        <td style="text-align: right" colspan="5">Total</td>
                        <td style="text-align: right"><span
                                style="font-weight:bold;">{{ number_format((float) $totalBill, 2, '.', '') }}</span>
                        </td>
                        <td style="text-align: right"><span
                                style="font-weight:bold;">{{ number_format((float) $totalPayment, 2, '.', '') }}</span>
                        </td>
                        <td style="text-align: right"><span
                                style="font-weight:bold;">{{ number_format((float) $totalDiscount, 2, '.', '') }}</span>
                        </td>
                    </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>
<script>
    function export2csv() {
        let data = "";
        const tableData = [];
        const rows = document.querySelectorAll("table#tableDownload tr");
        for (const row of rows) {
            const rowData = [];
            for (const [index, column] of row.querySelectorAll("th, td").entries()) {
                if ((index + 1) % 3 === 0) {
                    rowData.push('"' + column.innerText + '"');
                } else {
                    rowData.push(column.innerText);
                }
            }
            tableData.push(rowData.join(","));
        }
        data += tableData.join("\n");
        const a = document.createElement("a");
        a.href = URL.createObjectURL(new Blob([data], {
            type: "text/csv"
        }));
        a.setAttribute("download", "data.csv");
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }
    $(document).ready(function() {
        $('#tableDownload').DataTable();
    });
</script>
