@extends('layout.app')
@section('content')
    <div class="card">
        <div class="card-body">
            <h4 class="text-center">Please Enter New Bank Information</h4>
            <hr>
            <form action="{{ route('bank.store.withdraw') }}" method="POST">
                @csrf
                <div class="row">
                    <div class="col-md-6 m-auto">
                        <div>
                            <label for="">Bank Account No <span class="text-danger">*</span></label>
                            <select name="account_id" id="" class="form-control">
                                <option value="">Select Status</option>
                                @foreach ($bank_accounts as $bank_account)
                                    <option value="{{ $bank_account->id }}">{{ $bank_account->account_name }} --
                                        {{ $bank_account->bank_name }}</option>
                                @endforeach
                            </select>
                            @error('account_id')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Check No</label>
                            <input type="text" class="form-control" name="check_no" placeholder="Check No">
                        </div>
                        <div class="mt-3">
                            <label for="">Amount <span class="text-danger">*</span></label>
                            <input type="number" class="form-control" name="withdraw_amount" placeholder="Amount">
                            @error('withdraw_amount')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Withdraw By <span class="text-danger">*</span></label>
                            <input type="text" class="form-control" name="by" placeholder="Withdraw By">
                            @error('by')
                                <div class="text-danger">{{ $message }}</div>
                            @enderror
                        </div>
                        <div class="mt-3">
                            <label for="">Description</label>
                            <textarea class="form-control" name="description" rows="6" placeholder="Description"></textarea>
                        </div>

                        <button class="btn btn-success mt-4" style="float: right">Submit</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('js')
@endpush
