<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>{{ $page_title ?? 'Bank Transaction Report' }}</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th,
        td {
            border: 1px solid #000;
            padding: 4px 6px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
        }

        .text-right {
            text-align: right;
        }

        .text-center {
            text-align: center;
        }

        .mb-2 {
            margin-bottom: 8px;
        }
    </style>
</head>

<body>
    <h3 class="text-center">{{ $page_title ?? 'Bank Transaction Report' }}</h3>

    @if (!empty($filters))
        <div class="mb-2">
            <strong>Filters:</strong>
            @if (!empty($filters['search']))
                Search: {{ $filters['search'] }};
            @endif
            @if (!empty($filters['filter_by']))
                Filter By: {{ $filters['filter_by'] }};
            @endif
            @if (!empty($filters['date_from']))
                From: {{ $filters['date_from'] }};
            @endif
            @if (!empty($filters['date_to']))
                To: {{ $filters['date_to'] }};
            @endif
        </div>
    @endif

    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Account Name</th>
                <th>Account No</th>
                <th>Check No</th>
                <th>Bank Name</th>
                <th>Branch Name</th>
                <th>Description</th>
                <th>Deposit/Withdraw By</th>
                <th class="text-right">Deposit Amount (TK)</th>
                <th class="text-right">Withdraw Amount (TK)</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($bank_transfar as $transfar)
                <tr>
                    <td>{{ optional($transfar->created_at)->format('d-m-Y') }}</td>
                    <td>{{ optional($transfar->bank)->account_name }}</td>
                    <td>{{ optional($transfar->bank)->account_no }}</td>
                    <td>{{ $transfar->check_no }}</td>
                    <td>{{ optional($transfar->bank)->bank_name }}</td>
                    <td>{{ optional($transfar->bank)->branch_name }}</td>
                    <td>{{ $transfar->description }}</td>
                    <td>{{ $transfar->by }}</td>
                    <td class="text-right">{{ $transfar->diposit_amount }}</td>
                    <td class="text-right">{{ $transfar->withdraw_amount }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
</body>

</html>


