@extends('layout.app')

@section('content')
    <div class="card">
        <div class="card-header">
            <h3 class="card-title" style="color:#115548;">Purchase Add</h3>
            <div class="card-tools">
                <a href="{{ route('band-purchase.index') }}"><button class="btn btn-sm btn-primary"><i
                            class="fa fa-arrow-circle-left" aria-hidden="true"></i> &nbsp; Back</button></a>
            </div>
        </div>

        <div class="card-body">
            <form action="{{ route('band-purchase.store') }}" method="POST" class="" id="purchaseForm"
                enctype="multipart/form-data">
                @csrf

                <div class="row">
                    <div class="col-xl-3 col-md-3 col-12 mb-1">
                        <div class="form-group">
                            <label>Provider <span style="color: red">(require)</span></label>
                            <select class="form-control select2" name="provider_id" id="provider_id" required>
                                <option value="">Select One</option>
                                @foreach ($provider as $item)
                                    <option value="{{ $item->id }}">{{ $item->company_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>

                    <div class="col-xl-3 col-md-3 col-12 mb-1">
                        <div class="form-group">
                            <label>Invoice No <span style="color: red">(require)</span></label>
                            <input type="text" class="form-control" id="invoice_no" name="invoice_no">
                            <div id="invoiceWarning"></div>
                            @error('invoice_no')
                                <div class="text-danger mt-2 text-sm ">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    </div>

                    <div class="col-xl-3 col-md-3 col-12 mb-1">
                        <div class="form-group">
                            <label class="block text-gray-700 text-sm font-bold mb-2" for="billing_date">
                                Billing Date <span style="color: red">(require)</span>
                            </label>
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input type="text" id="billingDate" name="billing_date" value=""
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off" required>
                            </div>
                        </div>
                    </div>
                    <div class="form-group col-md-3">
                        <label for="document" class="block text-sm font-medium text-gray-700">
                            Document <span style="color: green">(optional)</span>
                        </label>
                        <input type="file" name="document" id="document" class="form-control" value="">
                    </div>
                    @php
                        $service = App\Models\BandService::all();
                    @endphp
                    <div class="col-md-4 mb-5">
                        <label>Select Service</label>
                        <select class="form-control " id="serviceId">
                            <option value="">Select One</option>
                            @foreach ($service as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>
                </div>
                <p class="text-danger h3">Note: By changing Billing Date all data will be reset</p>


                <div class="row">
                    <div class="table-responsive">
                        <table id="result" class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th style="padding-left: 2px;padding-right: 2px">Service </th>
                                    <th style="padding-left: 2px;padding-right: 2px">From Date</th>
                                    <th style="padding-left: 2px;padding-right: 2px">To Date</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Quantity(MB)</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Rate(TK)</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Vat(%)</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Value(Line Total)</th>
                                    <th style="padding-left: 2px;padding-right: 2px">Action</th>
                                </tr>
                            </thead>
                            <tbody>

                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12">
                        <div class="col-md-3 float-right">
                            <input type="number" class="form-control" id="totalPrice" name="totalPrice" autocomplete="off"
                                step=".01" min="0" readonly>
                        </div>
                        <div class="col-md-3 float-right">
                            Sub Total
                        </div>

                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <div class="col-md-3 float-right">
                            <input type="number" class="form-control" id="paidAmount" name="paidAmount" autocomplete="off"
                                value="0" step=".01" min="0">
                        </div>
                        <div class="col-md-3 float-right">
                            Paid <span style="color: green">(The paid amount will not be better than the total
                                amount.)</span>
                        </div>
                    </div>
                </div>
                <div class="row mt-2">
                    <div class="col-md-12">
                        <div class="col-md-3 float-right">
                            <input type="number" class="form-control" id="DueAmount" name="DueAmount"
                                autocomplete="off" step=".01" min="0" readonly>
                        </div>
                        <div class="col-md-3 float-right">
                            Due
                        </div>
                    </div>
                </div>
                @if (checkSettings('bank_account_withdraw') == 'enable')
                <div class="row mt-2">
                    <div class="col-md-12">
                        <div class="col-md-3 float-right">
                            <select name="bank_account_id" id="band_purchase_bank_account_id" class="form-control select2">
                                <option value="">Select Bank Account</option>
                                @php
                                    $bankAccounts = \App\Models\Banking::where('status', 1)->get();
                                @endphp
                                @if($bankAccounts->count() > 0)
                                    @foreach ($bankAccounts as $bankAccount)
                                        <option value="{{ $bankAccount->id }}">{{ $bankAccount->account_name }} -- {{ $bankAccount->bank_name }}</option>
                                    @endforeach
                                @endif
                            </select>
                        </div>
                        <div class="col-md-3 float-right">
                            Bank Account (Optional)
                            <small class="text-muted d-block">If selected, purchase amount will be withdrawn from this account.</small>
                        </div>
                    </div>
                </div>
                @endif
                <button class="btn btn-primary waves-effect waves-float waves-light float-right mt-2" type="submit"
                    id="submitButton">Submit
                </button>
            </form>
        </div>
    </div>

    <style>
        li.selected {
            background: #17A2B8 !important;
        }
    </style>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
@endsection

@section('ajax')
    <script src="{{ asset('adminlte/js/jquery.validate.js') }}"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/moment@2.29.1/moment.min.js"></script>


    <script type="text/javascript">
        $(function() {
            $('#invoice_no').on('change', function() {
                $.ajax({
                    type: 'get',
                    url: '{{ route('checkInvoiceNo') }}',
                    data: {
                        inv: $(this).val()
                    },
                    success: function(data) {
                        if (data != true) {
                            $('#invoice_no').css('border', '1px solid red');
                            $('#invoiceWarning').html(
                                '<span style="color:red">Already Exist</span>');
                        } else {
                            $('#invoice_no').css('border', '1px solid #ddd');
                            $('#invoiceWarning').html(
                                '<span style="color:green">You can use</span>');
                        }
                    }
                });
            });
        });
    </script>

    <script>
        let billinngMonth = null;
        let firstDay = null;
        let lastDay = null;
        $(document).ready(function() {
            $('#billingDate').on('blur change', function() {
                billinngMonth = $(this).val();
                dateStr = billinngMonth;
                var dateParts = dateStr.split('/');
                var month = parseInt(dateParts[0], 10) - 1; // Months are 0-based in JavaScript Date
                var day = parseInt(dateParts[1], 10);
                var year = parseInt(dateParts[2], 10);

                var date = new Date(year, month, day);


                firstDay = new Date(date.getFullYear(), date.getMonth(), 1);


                lastDay = new Date(date.getFullYear(), date.getMonth() + 1, 0);

                $('#result tbody').empty();
                setToalAndSubTrackPaidAmount();

            });
        });




        function formatDateString(date) {
            let day = date.getDate();
            let month = date.getMonth() + 1; // Months are 0-based in JavaScript Date
            let year = date.getFullYear();
            return `${day}-${month}-${year}`;
        }

        function myFunction() {}

        // Function to get the first day of the current month
        function getFirstDayOfMonth() {

            if (billinngMonth) {
                return formatDateString(firstDay);
            } else {

                var today = new Date();
                var firstDayOfMonth = new Date(today.getFullYear(), today.getMonth(), 1);
                return firstDayOfMonth;
            }
        }

        // Function to get the last day of the current month
        function getLastDayOfMonth() {

            if (billinngMonth) {
                return formatDateString(lastDay);
            } else {

                var today = new Date();
                var lastDayOfMonth = new Date(today.getFullYear(), today.getMonth() + 1, 0);
                return lastDayOfMonth;
            }
        }

        function getDaysInCurrentMonth() {
            if (billinngMonth) {
                return lastDay.getDate();
            } else {

                var now = new Date();
                var year = now.getFullYear();
                var month = now.getMonth();

                // Create a date object for the first day of the next month
                var nextMonth = new Date(year, month + 1, 1);

                // Subtract one day to get the last day of the current month
                var lastDayOfCurrentMonth = new Date(nextMonth - 1);

                return lastDayOfCurrentMonth.getDate();
            }
        }

        const fetchData = (productId) => {

            searchResult(productId);
        }

        $('#serviceId').change(() => {

            var serviceSelect = $('#serviceId').val();

            if (serviceSelect) {

                fetchData(serviceSelect);
            }

        });

        function searchResult(productId) {
            $.ajax({
                type: 'get',
                url: '{{ route('productinfo') }}',
                data: {
                    data: productId
                },
                success: function(res) {

                    r = res;
                    var check = 0;

                    var id = $('#serviceId').val();

                    if (check == 0) {
                        $('#result tbody').append('<tr>' +
                            '<td style="padding-left: 2px; align: center; display:none"><input style="width: 90px" class="product_id" value="' +
                            r.id + '" type="number" name="service_id[]" required></td>' +
                            '<td style="padding-left: 2px"><lable style="width: 50px" class="product_name"> ' +
                            r.name + '</td>' +

                            '<td style="padding-left: 2px"><input style="width: 150px" class="formDate" id="from" type="text" required name="from_date[]"></td>' +
                            '<td style="padding-left: 2px"><input style="width: 150px" class="toDate" id="to" type="text" required name="to_date[]"></td>' +

                            '<td style="padding-left: 2px"><input style="width: 150px" class="quantity" min="0" value="0" type="number" step="0.001" required name="quantity[]" ></td>' +
                            '<td style="padding-left: 2px"><input style="width: 150px" class="rate" min="0" value="0" type="number" step="0.01" required name="rate[]"></td>' +
                            '<td style="padding-left: 2px"><input style="width: 150px" class="vat" min="0" value="0" type="number" step="0.01" required name="vat[]" ></td>' +
                            '<td style="padding-left: 2px"><input style="width: 150px" class="lineTotal" min="0" value="0" type="number" step="0.01" readonly required name="lineTotal[]"></td>' +
                            '<td style="padding-left: 2px"><button type="button" name="remove" class="btn btn-danger btn-sm remove"><i class="fa fa-minus-circle"></i></button></td>' +
                            '</tr>');

                        // getValue();

                        $(function() {
                            $(".formDate").flatpickr({
                                dateFormat: "d-m-Y",
                                minDate: getFirstDayOfMonth(),
                                maxDate: getLastDayOfMonth()
                            });
                        });

                        $(function() {
                            $(".toDate").flatpickr({
                                dateFormat: "d-m-Y",
                                minDate: getFirstDayOfMonth(),
                                maxDate: getLastDayOfMonth()
                            });
                        });
                    } else {
                        alert('Product already added.');
                    }
                }
            });
        }

        function getValue(thisObj) {

            var totalSum = 0;
            var subTotal = 0;

            $("tr").each(function() {
                var qty = parseFloat(thisObj.parents("tr").find("input.quantity").val()) || 0;
                var rate = parseFloat(thisObj.parents("tr").find(".rate").val()) || 0;
                var vat = parseFloat(thisObj.parents("tr").find(".vat").val()) || 0;
                let form_date = thisObj.parents("tr").find(".formDate").val();
                let to_date = thisObj.parents("tr").find(".toDate").val();


                let days = calculateDateDifference(form_date, to_date);
                let totalDaysInThisMonth = getDaysInCurrentMonth();


                let lineTotal = 0;
                if (totalDaysInThisMonth === days) {
                    lineTotal = qty * rate;
                } else {
                    lineTotal = ((qty * rate) / totalDaysInThisMonth) * days;
                }



                let totalVat = 0;
                if (vat > 0) {
                    totalVat = (lineTotal * vat) / 100;
                }

                let lineTotalWithVat = lineTotal + totalVat;


                thisObj.parents("tr").find(".lineTotal").val(lineTotalWithVat.toFixed(2));
            });

            setToalAndSubTrackPaidAmount();


        };

        function setToalAndSubTrackPaidAmount() {
            let sumOfLineTotal = 0;
            $("tr .lineTotal").each(function(index, value) {

                thisLineTotal = parseFloat($(this).val());
                sumOfLineTotal = sumOfLineTotal + thisLineTotal;

            });

            $('#totalPrice').val(sumOfLineTotal.toFixed(2));

            let paidAmount = $('#paidAmount').val();

            let due = 0;
            due = sumOfLineTotal - paidAmount;

            $('#DueAmount').val(due.toFixed(2));

        };





        function calculateDateDifference(startDate, endDate) {
            var start = moment(startDate, "DD-MM-YYYY");
            var end = moment(endDate, "DD-MM-YYYY");
            var difference = end.diff(start, 'days') + 1;
            return Math.abs(difference);
        }

        $(document).on("keyup", ".vat", function(event) {
            getValue($(this));
        });

        $(document).on("keyup", ".rate", function(event) {
            getValue($(this));
        });

        $(document).on("keyup", ".quantity", function(event) {
            getValue($(this));
        });
        $(document).on("change", ".formDate", function(event) {
            getValue($(this));
        });
        $(document).on("change", ".toDate", function(event) {
            getValue($(this));
        });
        $(document).on("keyup", "#paidAmount", function(event) {
            setToalAndSubTrackPaidAmount();
        });
        $(document).on("click", ".remove", function(event) {
            $(this).closest("tr").remove();
            setToalAndSubTrackPaidAmount();
        });

        $('#purchaseForm').on('submit', function(e) {
            // Clear any previous error messages
            $('.validation-error').remove();

            let isValid = true;
            let errorMessages = [];

            // 1. Validate Provider
            const providerId = $('#provider_id').val();
            if (!providerId) {
                isValid = false;
                errorMessages.push('Please select a provider');
                $('#provider_id').css('border', '2px solid red');
            } else {
                $('#provider_id').css('border', '1px solid #ddd');
            }

            // 2. Validate Invoice No
            const invoiceNo = $('#invoice_no').val().trim();
            if (!invoiceNo) {
                isValid = false;
                errorMessages.push('Please enter an invoice number');
                $('#invoice_no').css('border', '2px solid red');
            } else if ($('#invoiceWarning').text().includes('Already Exist')) {
                isValid = false;
                errorMessages.push('Invoice number already exists');
                $('#invoice_no').css('border', '2px solid red');
            } else {
                $('#invoice_no').css('border', '1px solid #ddd');
            }

            // 3. Validate Billing Date
            const billingDate = $('#billingDate').val();
            if (!billingDate) {
                isValid = false;
                errorMessages.push('Please select a billing date');
                $('#billingDate').css('border', '2px solid red');
            } else {
                $('#billingDate').css('border', '1px solid #ddd');
            }

            // 4. Validate Table Rows (at least one service must be added)
            const rowCount = $('#result tbody tr').length;
            if (rowCount === 0) {
                isValid = false;
                errorMessages.push('Please add at least one service to the purchase');
            }

            // 5. Validate each row in the table
            let rowErrors = [];
            $('#result tbody tr').each(function(index) {
                const rowNum = index + 1;
                const $row = $(this);

                // Check service name
                const serviceName = $row.find('.product_name').text().trim();
                if (!serviceName) {
                    rowErrors.push(`Row ${rowNum}: Service name is missing`);
                }

                // Check from date
                const fromDate = $row.find('.formDate').val();
                if (!fromDate) {
                    rowErrors.push(`Row ${rowNum}: From date is required`);
                    $row.find('.formDate').css('border', '2px solid red');
                } else {
                    $row.find('.formDate').css('border', '1px solid #ddd');
                }

                // Check to date
                const toDate = $row.find('.toDate').val();
                if (!toDate) {
                    rowErrors.push(`Row ${rowNum}: To date is required`);
                    $row.find('.toDate').css('border', '2px solid red');
                } else {
                    $row.find('.toDate').css('border', '1px solid #ddd');
                }

                // Validate date range (from date should be before or equal to to date)
                if (fromDate && toDate) {
                    const from = moment(fromDate, "DD-MM-YYYY");
                    const to = moment(toDate, "DD-MM-YYYY");
                    if (from.isAfter(to)) {
                        rowErrors.push(`Row ${rowNum}: From date cannot be after To date`);
                        $row.find('.formDate, .toDate').css('border', '2px solid red');
                    }
                }

                // Check quantity
                const quantity = parseFloat($row.find('.quantity').val());
                if (isNaN(quantity) || quantity <= 0) {
                    rowErrors.push(`Row ${rowNum}: Quantity must be greater than 0`);
                    $row.find('.quantity').css('border', '2px solid red');
                } else {
                    $row.find('.quantity').css('border', '1px solid #ddd');
                }

                // Check rate
                const rate = parseFloat($row.find('.rate').val());
                if (isNaN(rate) || rate <= 0) {
                    rowErrors.push(`Row ${rowNum}: Rate must be greater than 0`);
                    $row.find('.rate').css('border', '2px solid red');
                } else {
                    $row.find('.rate').css('border', '1px solid #ddd');
                }

                // Check VAT (can be 0 or positive)
                const vat = parseFloat($row.find('.vat').val());
                if (isNaN(vat) || vat < 0) {
                    rowErrors.push(`Row ${rowNum}: VAT cannot be negative`);
                    $row.find('.vat').css('border', '2px solid red');
                } else {
                    $row.find('.vat').css('border', '1px solid #ddd');
                }

                // Check line total
                const lineTotal = parseFloat($row.find('.lineTotal').val());
                if (isNaN(lineTotal) || lineTotal <= 0) {
                    rowErrors.push(`Row ${rowNum}: Line total must be greater than 0`);
                }
            });

            // Add row errors to main error messages
            if (rowErrors.length > 0) {
                isValid = false;
                errorMessages = errorMessages.concat(rowErrors);
            }

            // 6. Validate Total Price
            const totalPrice = parseFloat($('#totalPrice').val());
            if (isNaN(totalPrice) || totalPrice <= 0) {
                isValid = false;
                errorMessages.push('Total price must be greater than 0');
            }

            // 7. Validate Paid Amount
            const paidAmount = parseFloat($('#paidAmount').val());
            if (isNaN(paidAmount) || paidAmount < 0) {
                isValid = false;
                errorMessages.push('Paid amount cannot be negative');
                $('#paidAmount').css('border', '2px solid red');
            } else if (paidAmount > totalPrice) {
                isValid = false;
                errorMessages.push('Paid amount cannot be greater than total amount');
                $('#paidAmount').css('border', '2px solid red');
            } else {
                $('#paidAmount').css('border', '1px solid #ddd');
            }

            // If validation fails, prevent form submission and show errors
            if (!isValid) {
                e.preventDefault();

                // Create error message HTML
                let errorHtml = '<div class="alert alert-danger alert-dismissible validation-error" role="alert">';
                errorHtml += '<button type="button" class="close" data-dismiss="alert" aria-label="Close">';
                errorHtml += '<span aria-hidden="true">&times;</span></button>';
                errorHtml += '<h5><i class="icon fas fa-ban"></i> Validation Error!</h5>';
                errorHtml += '<ul>';
                errorMessages.forEach(function(msg) {
                    errorHtml += '<li>' + msg + '</li>';
                });
                errorHtml += '</ul></div>';

                // Insert error message at the top of the form
                $('.card-body').prepend(errorHtml);

                // Scroll to top to show errors
                $('html, body').animate({
                    scrollTop: $('.card-body').offset().top - 100
                }, 500);

                return false;
            }

            // If all validations pass, show loading state
            $('#submitButton').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Submitting...');

            return true;
        });
    </script>
@endsection
