<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="icon" type="image/png" href="{{ asset('storage/company/' . siteinfo()->img_url ?? '') }}">
    {{-- <link rel="icon" type="image/jpeg" href="{{ asset('storage/company/' . siteinfo()->img_url ?? '') }}"> --}}

    <link rel="stylesheet" href="{{ asset('loginAsset/fonts/icomoon/style.css') }}">

    <link rel="stylesheet" href="{{ asset('loginAsset/css/owl.carousel.min.css') }}">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ asset('loginAsset/css/bootstrap.min.css') }}">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css"
    integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA=="
    crossorigin="anonymous"
    referrerpolicy="no-referrer" />
    <script src="{{ asset('/') }}plugins/jquery/jquery.min.js"></script>

    <title>Radius | YetFix Limited</title>
</head>

<body class="authentication-page">
    <div class="container-fluid">

        <div class="row">
            <div class="d-none d-sm-none d-md-block    col-md-8 h-100 pr-0 pl-0 position-relative" style="overflow: hidden;">

                @if (siteinfo()->landing_image)
                    <img src="{{ asset('storage/company/' . siteinfo()->landing_image) }}" alt="yetfix authentication way" class="img-fluid poster">
                @else
                    <img src="{{ asset('auth-image/yetfixposter.png') }}" alt="yetfix authentication way" class="img-fluid poster">
                @endif


            </div>

            <div class="col-sm-12 col-md-4  d-flex flex-column justify-content-center close-overflow shadow-lg border-l"
                style=" z-index:1;">
                <div class="text-center  mb-4 mt-3 loginsection">

                    @if (siteinfo()->img_url)
                        <img src="{{ asset('storage/company/' . siteinfo()->img_url ?? '') }}" alt="Image"
                            class="img-fluid logo">
                    @else
                        <img src="{{ asset('loginAsset/images/logobillingfix.png') }}" alt="Image"
                            style="width: 185px;">
                        <p style="color: gray;  font-weight:bold">Your ISP Billing
                            Solution </p>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                </div>

                <div class="w-75 mx-auto p-3 ">
                    <x-auth-session-status class="form-group" :status="session('status')" />
                </div>


                <form method="POST" action="{{ route('login') }}" class="w-100 rounded px-5 mx-auto" id="logInForm">
                    @csrf
                    <h3 class="login-head">Admin Login</h3>

                    <div class="form-group position-relative mt-4">
                        <label class="form-label sr-only" for="form2Example11">Email</label>
                        <i class="fa-solid fa-user icon-placeholder text-dark"></i>
                        <input type="email" name="email" id="form2Example11" class="form-control text-center"
                            placeholder="email address" required />
                    </div>
                    @error('email')
                        <span class="text-danger">{{ $message }}</span>
                    @enderror

                    <div class="form-group position-relative mt-4">
                        <label class="form-label sr-only" for="form2Example22">Password</label>
                        <i class="fa-regular fa-eye icon-placeholder text-dark" id="eye-icon" onclick="passwordCloserDiscloser()"></i>
                        <input type="password" name="password" id="form2Example22" class="form-control custom-input"
                            placeholder="password" required />
                    </div>

                    <div class="form-outline mb-4">
                        <label for="remember" class="mt-1 mr-2" style="vertical-align:middle">
                            <input type="checkbox" name="remember" value="1" id="remember" class="form-controll custom-input">
                            Remember me</label>
                    </div>

                    <div class="text-center pt-1 mb-5 mobile-mb-0 pb-1">
                        <button type="submit" class="btn btn-purple btn-block gradient-custom-2 mb-3" id="logInBtn">Log in</button>
                    </div>
                </form>

                <div style="max-width:1200px;margin:0 auto;" class="">
                    <div class="text-center p-4">
                        Copyright © 2020-{{ date('Y') }}
                        <a class="text-reset fw-bold" href="http://yetfix.com/">YetFix Limited.</a> | <a
                            class="text-center fw-bold" href="{{ route('privacyPolicy') }}" target="_blank">Privacy
                            Policy</a>
                    </div>
                </div>
            </div>
        </div>
    </div>



</body>
<script>
    $(document).ready(function () {
        $("#logInForm").submit(function (e) {
            // Disable the button to prevent multiple clicks
            $("#logInBtn").prop("disabled", true).text("Submitting...");
        });
    });
</script>
</html>


<style>
    @import url('https://fonts.googleapis.com/css2?family=Nunito+Sans:opsz,wght@6..12,400;6..12,500;6..12,600;6..12,700;6..12,800&display=swap');

    .authentication-page {
        margin: 0;
        padding: 0;
        height: 100vh;
        font-family: 'Nunito Sans', sans-serif;

    }

    .btn-purple {
        background: #38bdf8;
        color: #FFFF;
    }

    .btn-purple:hover {
        background: #209bd0;
        color: #FFFF;
    }

    label {
        letter-spacing: 0.05em;
    }

    .form-control:focus {
        border-color: #a03173;
        box-shadow: 0 0 10px rgba(255, 153, 0, 0.5);
    }


    @media(max-width: 767px) {
        .poster {
            overflow: hidden;
            height: 100%;
            width: 100%;
            position: relative;
            /* object-fit: contain; */
        }
    }

    @media(min-width: 767px) {
        .poster {
            overflow: hidden;
            height: 100vh;
            width: 100%;
            position: relative;
            /* object-fit: contain; */
        }
    }

    .form-control::placeholder {
        letter-spacing: 0.05em;
        font-size: 18px;
        text-align: start;
        padding-left: 10px !important;
    }

    .login-head {
        letter-spacing: 0.05em;
        text-align: center;

    }




    .logo {
        width: 105px;
        height: 105px;
        border-radius: 9%;
    }

    @media only screen and (min-width:1200px) and (max-width:1366px) {
        .loginsection {
            margin-top: 2px !important;
            margin-botttom: 2px !important;
        }

        .logo {
            width: 80px;
            height: auto;
        }

        .mobile-mb-0 {
            margin-bottom: 0 !important;
        }

        .login-head {
            font-size: 20px;
            color: #0284c7
        }
    }

    @media only screen and (min-width:1367px) and (max-width:1920px) {
        .loginsection {
            margin-top: 3px !important;
            margin-botttom: 3px !important;
        }

        .logo {
            width: 105px;
            height: 105px;
        }

        .mobile-mb-0 {
            margin-bottom: 0 !important;
        }

        .login-head {
            font-size: 50px;
            color: #38bdf8;
        }
    }

    .sr-only {
        position: absolute;
        width: 1px;
        height: 1px;
        padding: 0;
        margin: -1px;
        overflow: hidden;
        clip: rect(0, 0, 0, 0);
        border: 0;
    }


    .btn-purple {
        background: rgb(35, 10, 118, 0.7);
        color: #FFFF;
    }

    .btn-purple:hover {
        background: rgb(35, 10, 118, 0.9);
        color: #FFFF;
    }

    label {
        letter-spacing: 0.05em;
    }

    .form-control:focus {

        box-shadow: 0 0 10px rgba(255, 153, 0, 0.5);
        color: #000000;



    }


    @media(max-width: 767px) {
        .poster {
            height: 100%;
            width: 100%;
            position: relative;

        }
    }

    @media(min-width: 767px) {
        .poster {
            height: 100vh;
            position: relative;
            width: 100%;

        }
    }

    .form-control::placeholder {
        letter-spacing: 0.05em;
        font-size: 16px;
        color: #000000;
        text-align: center;

    }

    .custom-input {
        background: inherit;
        text-align: center;
        color: #000000;
    }

    /* Override autofill background color */
    .custom-input:not(:placeholder-shown) {
        background-color: inherit !important;
    }



    .login-head {
        letter-spacing: 0.05em;
        text-align: center;
        margin-bottom: 36px;
        font-size: 16px;

    }




    @media only screen and (min-width:1367px) and (max-width:1920px) {
        .loginsection {
            margin-top: 3px !important;
            margin-botttom: 3px !important;
        }

        .logo {
            width: 105px;
            height: 105px;
            border-radius: 9%;
        }

        .mobile-mb-0 {
            margin-bottom: 0 !important;
        }

        .login-head {
            font-size: 22px;
        }
    }


    .icon-placeholder {
        position: absolute;
        bottom: 10px;
        left: 15px;
    }

    @media(max-width:412px) {
        .icon-placeholder {
            bottom: 10px;
            left: 8px;

        }
    }





    @media only screen and (min-width:1200px) and (max-width:1366px) {


        .logo {
            width: 80px;
            height: auto;
        }
    }

    @media only screen and (min-width:1367px) and (max-width:1920px) {


        .logo {
            width: 105px;
            height: 105px;
        }

    }



</style>


<script>
    

    const passwordShowerIcon = document.getElementById("eye-icon");
    const passwordInputContainer = document.getElementById("form2Example22");
    const passwordCloserDiscloser = function(){
        if(passwordInputContainer.type==='password'){
            passwordInputContainer.setAttribute("type",'text');
        }else{
            passwordInputContainer.setAttribute("type",'password');
        }
    }
</script>
