{{-- <a class="noprint btn btn-primary" target="_blank" href="{{ route('printIncome') }}"><i
    class="fa fa-print"></i> Print without Price</a> --}}
    
    <div class="col-md-12">
        
        <button class="btn btn-primary p-1" onclick="export2csv()">Download csv</button>
        <div class=" float-right d-flex amount-container" style="text-align:center; gap:3px !important; ">

            <p class=" p-1" style="border:2px solid #fed7aa; ">Total Result: {{ $incomes->count() }}</p>
            <p class="p-1 " style="border:2px solid #fed7aa; ">Total Amount: {{ $incomes->sum('amount') }} </p>     
                
        </div>
    </div>

<div class="table-responsive">
<table id="dataTable" class="table">
    <thead class="bg-blue-50">
        <tr>
            <th scope="col" class="___class_+?2___">
                Sl No
            </th>
            <th scope="col" class="___class_+?3___">
                Income Id
            </th>

            <th scope="col" class="___class_+?4___">
                Name
            </th>
            <th scope="col" class="___class_+?4___">
                Income Head
            </th>
            <th scope="col" class="___class_+?5___">
                Date
            </th>

            <th scope="col" class="___class_+?6___">
                Invoice No
            </th>

            <th scope="col" class="___class_+?7___">
                Description
            </th>

            <th scope="col" class="___class_+?7___">
                Amount
            </th>

        </tr>
    </thead>
    <tbody class="bg-white divide-y divide-gray-200">
        @foreach ($incomes as $item)
            <tr>
                <td>{{ $loop->iteration }}</td>
                {{-- <td>{{ $item->expense->name }}</td> --}}
                <td>{{ $item->id }}</td>
                <td>{{ $item->name }}</td>
                <td>{{ $item->head->name ?? '' }}</td>
                <td>{{ $item->date }}</td>
                {{-- <td>{{ date('d-M-Y g:i: a ', strtotime($item->date)) }}</td> --}}
                <td>{{ $item->invoice_number }}</td>
                <td>{{ $item->description }}</td>
                <td>{{ $item->amount }}</td>
            </tr>
        @endforeach
        <tr>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td></td>
            <td  class="text-right">Total</td>
            <td>{{ $incomes->sum('amount') }} TK</td>
        </tr>
    </tbody>
</table>
</div>
<script>
    function export2csv() {
        let data = "";
        const tableData = [];
        const rows = document.querySelectorAll("table#dataTable tr");
        for (const row of rows) {
            const rowData = [];
            for (const [index, column] of row.querySelectorAll("th, td").entries()) {
            // To retain the commas in the "Description" column, we can enclose those fields in quotation marks.
            if ((index + 1) % 3 === 0) {
                rowData.push('"' + column.innerText + '"');
            } else {
                rowData.push(column.innerText.replace(',',''));
            }
            }
            tableData.push(rowData.join(","));
        }
        data += tableData.join("\n");
        const a = document.createElement("a");
        a.href = URL.createObjectURL(new Blob([data], { type: "text/csv" }));
        a.setAttribute("download", "income.csv");
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }
</script>

<style>
    .amount-container{
        flex-direction: column;
    }
    @media (min-width:640px){
        .amount-container{
            flex-direction: row;
        }
    }
</style>