@extends('Customer.customer-layout')

@section('body')
    @include('Customer.left-menu')

    <main id="main" class="main">
        <div class="pagetitle">
            <h1>Token List</h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="{{ route('customerDashboard') }}">Home</a></li>
                    <li class="breadcrumb-item active">TokenList</li>
                </ol>
            </nav>
        </div><!-- End Page Title -->

        <section class="section">

            <div class="col-lg-12">


                <h5>Token List</h5>

                <!-- Table with stripped rows -->
                <table class="table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Token#</th>
                            <th>Category(Code)</th>
                            <th>Description</th>
                            <th>Info</th>
                            <th>Contact</th>
                            <th>Creator</th>
                            <th>Assigned</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($token as $r)
                            <tr>
                                <td>{{ $r->id }}</td>
                                <td>
                                    T.ID : {{ $r->token }} <br>
                                    Create Time : {{ date('d-M-Y g:i: a ', strtotime($r->created_at)) }} <br>
                                    @if ($r->status == 'Active')
                                        <span class="badge bg-danger">Pending</span>
                                    @else
                                        <span class="badge bg-success">Closed</span>
                                    @endif
                                </td>
                                <td>{{ $r->category->tokenCategory ?? '' }} ({{ $r->Code->tokenCode ?? '' }})</td>
                                <td>{{ $r->description }}</td>
                                <td>
                                    <p style="font-size:14px;">
                                        @if (!empty($r->clients->clientsInfo->clients_name))
                                            C Name : {{ $r->clients->clientsInfo->clients_name ?? '' }} <br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->flat_no))
                                            Flat No: {{ $r->clients->clientsinfo->flat_no ?? '' }},
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->building_name))
                                            Building Name: {{ $r->clients->clientsinfo->building_name ?? '' }},<br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->road_no))
                                            Road No: {{ $r->clients->clientsinfo->road_no ?? '' }},<br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->block_sector))
                                            Block/Sector: {{ $r->clients->clientsinfo->block_sector ?? '' }},
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->area))
                                            Area : {{ $r->clients->clientsinfo->area ?? '' }}, <br>
                                        @endif
                                        @if (!empty($r->clients->clientsinfo->box))
                                            Box : {{ $r->clients->clientsinfo->box ?? '' }}
                                        @endif
                                    </p>
                                </td>
                                <td>{{ $r->reporterContact }}</td>
                                <td>{{ $r->creator->name ?? '' }} {{ $r->createByClient ?? '' }}</td>
                                <td>{{ $r->employees->name ?? '' }}</td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
                <!-- End Table with stripped rows -->


            </div>

        </section>
    </main><!-- End #main -->
@endsection
