@extends('Customer.customer-layout')

@section('body')
    @include('Customer.left-menu')

    <main id="main" class="main mb-5">

        <a href="{{ route('customerDashboard') }}" class="btn-sm bg-dark text-white mb-3"><i class="fa fa-arrow-left"></i>Back
            To Dashboard</a>

        <div class="card card-body mt-3">
            <div class="pagetitle mt-2">
                <h1>Bill Pay</h1>
                <nav>
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('customerDashboard') }}">Home</a></li>
                        <li class="breadcrumb-item active">Bill Pay</li>
                    </ol>
                </nav>

            </div><!-- End Page Title -->

            <section class="section profile">
                <div class="table-responsive">
                    <table class="table table-responsive table-bordered">
                        <tr>
                            <th>Paid Amount</th>
                            <th>Description</th>
                            <th>Payment Date</th>
                            <th></th>
                        </tr>

                        @foreach ($details['paymentinfo'] as $r)
                            <tr>
                                <td class="text-right">
                                    {{ $r->paid_amount }}
                                </td>
                                <td>
                                    {{ $r->description }}
                                </td>
                                <td>
                                    {{ date('d-M-Y h:i:a', strtotime($r->created_at)) }}
                                </td>
                                <td>
                                    <a href="{{ route('singleInvoice', $r->id) }}" class="btn btn-info btn-xs"><i class="bi bi-printer"></i></a>
                                </td>
                            </tr>
                        @endforeach


                    </table>

                    <div class="">
                        {{ $details['paymentinfo']->onEachSide(2)->links() }}
                    </div>
                </div>
            </section>

        </div>

    </main>


    </div>
    </div>

    {{-- {{dd($details)}} --}}
@endsection
