<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="icon" type="image/png" href="{{ asset('storage/company/' . siteinfo()->img_url ?? '') }}">
    {{-- <link rel="icon" type="image/jpeg" href="{{ asset('storage/company/' . siteinfo()->img_url ?? '') }}"> --}}

    <link rel="stylesheet" href="{{ asset('loginAsset/fonts/icomoon/style.css') }}">

    <link rel="stylesheet" href="{{ asset('loginAsset/css/owl.carousel.min.css') }}">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="{{ asset('loginAsset/css/bootstrap.min.css') }}">

    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css"
        integrity="sha512-z3gLpd7yknf1YoNbCzqRKc4qyor8gaKU1qmn+CShxbuBusANI9QpRohGBreCFkKxLhei6S9CQXFEbbKuqLg0DA=="
        crossorigin="anonymous" referrerpolicy="no-referrer" />
    <title>YetFix Radius | Customer Login</title>
</head>

<body class="authentication-page ">
    <div class="container-fluid">

        <div class="row">


            <div class=" col-sm-12 col-md-4  d-flex flex-column justify-content-center text-light"
                style=" z-index:1; background: #ffffff; min-height:100vh;">


                <div class="w-75 mx-auto p-3 ">

                    <x-auth-session-status class="form-group" :status="session('status')" />

                </div>

                <div class="text-center  mb-4 mt-3 loginsection">

                    @if (siteinfo()->img_url)
                        <img src="{{ asset('storage/company/' . siteinfo()->img_url ?? '') }}" alt="Image"
                            class=" logo " width="105" height="105">
                    @else
                        <img src="{{ asset('loginAsset/images/logobillingfix.png') }}" alt="Image" width="105"
                            height="105" class="logo">
                        <p style="color: gray; font-weight:bold">Your ISP Billing
                            Solution </p>
                    @endif

                    @if (session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                </div>

                <form method="POST" action="{{ route('customer_login_check') }}" class="w-100 rounded   mx-auto ">

                    <h1 class="login-head " style="color:#000000;">Customer Login</h1>

                    @if (checksettings('customer-login-by-cid-mobileNumber') == 'enable')
                        <div class="form-group position-relative">
                            <label class="form-label sr-only" for="Cid">Cid</label>
                            <i class="fa-solid fa-user icon-placeholder"></i>
                            <input type="text" name="id" id="Username" placeholder="Cid"
                                class="form-control custom-input" required autocomplete="off" />
                        </div>

                        {{-- Cid error and success start --}}
                        @if (session('error_message'))
                            <div class="mb-4 d-block " role="alert"
                                style="color:#ef4444; background:rgba(71, 71, 67, 0.356);">
                                {{ session('error_message') }}
                            </div>
                        @endif


                        @if (session('success_message'))
                            <div class="text-dark  mb-4" role="alert" style="">
                                {{ session('success_message') }}
                            </div>
                        @endif
                        {{-- Cid error and success end --}}

                        <div class="form-group position-relative">
                            <label class="form-label sr-only" for="Password">Password</label>
                            <i class="fa-solid fa-lock icon-placeholder"></i>
                            <input type="text" name="mobileNumber" id="password" placeholder="Mobile Number"
                                class="form-control custom-input" required autocomplete="off" />
                        </div>
                    @elseif (checksettings('login_customer_code_and_password') == 'enable')
                        <div class="form-group position-relative">
                            <label class="form-label sr-only" for="Customer_code">Customer code</label>
                            <i class="fa-solid fa-user icon-placeholder"></i>
                            <input type="text" name="code" id="Username" placeholder="Customer code"
                                class="form-control custom-input" required autocomplete="off" />
                        </div>
                        @if (session('error_message'))
                            <div class="mb-4 d-block " role="alert"
                                style="color:#ef4444; background:rgba(71, 71, 67, 0.356);">
                                {{ session('error_message') }}
                            </div>
                        @endif
                        @if (session('success_message'))
                            <div class="text-dark  mb-4" role="alert" style="">
                                {{ session('success_message') }}
                            </div>
                        @endif
                        <div class="form-group position-relative">
                            <label class="form-label sr-only" for="Password">Password</label>
                            <i class="fa-solid fa-lock icon-placeholder"></i>
                            <input type="text" name="password" id="password" placeholder="Password"
                                class="form-control custom-input" required autocomplete="off" />
                        </div>
                    @else
                        <div class="form-group position-relative">
                            <label class="form-label sr-only" for="Username">Username</label>
                            <i class="fa-solid fa-user icon-placeholder text-dark"></i>

                            <input type="text" name="username" id="username" class="form-control custom-input"
                                placeholder="Username" required autocomplete="off" />
                        </div>

                        {{-- username error and success start --}}
                        @if (session('error_message'))
                            <div class="d-block   p-1" role="alert"
                                style="color:#ef4444; background:rgba(71, 71, 67, 0.356);">
                                {{ session('error_message') }}
                            </div>
                        @endif


                        @if (session('success_message'))
                            <div class="text-white  " role="alert">
                                {{ session('success_message') }}
                            </div>
                        @endif

                        {{-- username error and success end --}}

                        <div class="form-group position-relative mt-4 ">
                            <label class="form-label sr-only" for="password">Password</label>
                            <i class="fa-solid fa-lock icon-placeholder text-dark"></i>

                            <input type="password" name="password" id="password" class="form-control custom-input"
                                placeholder="Password" required />

                        </div>
                    @endif


                    <div class="text-center pt-1 mb-1 pb-1">
                        <button type="submit" class="btn btn-purple btn-block gradient-custom-2 mb-3">Login</button>
                    </div>
                </form>

                <div class="text-center pt-1 mb-5 pb-1">
                    <a href="{{ route('client-register.create') }}" class="btn btn-primary btn-block gradient-custom-2 mb-3">Register For New Connection Request</a>
                </div>

                <div style="max-width:1200px;margin:0 auto;" class="mt-5">
                    <div class="text-center p-4 text-dark">
                        Copyright © 2020-{{ date('Y') }} YetFix Limited. | <a
                            class="text-center fw-bold text-dark" href="{{ route('privacyPolicy') }}"
                            target="_blank">Privacy
                            Policy</a>
                    </div>
                </div>
            </div>

            <div class="d-none d-sm-none d-md-block  col-md-8 h-100 pr-0 pl-0 position-relative"
                style="overflow: hidden;min-height:100vh;">
                @if (siteinfo()->landing_image)
                    <img src="{{ asset('storage/company/'.siteinfo()->landing_image) }}" alt="yetfix authentication way"
                        class="img-fluid poster">
                @else
                    <img src="{{ asset('auth-image/yetfixposter.png') }}" alt="yetfix authentication way"
                        class="img-fluid poster">
                @endif



            </div>


        </div>
    </div>



</body>

</html>


<style>
    @import url('https://fonts.googleapis.com/css2?family=Nunito+Sans:opsz,wght@6..12,400;6..12,500;6..12,600;6..12,700;6..12,800&display=swap');

    .authentication-page {
        margin: 0;
        padding: 0;
        height: 100vh;
        font-family: 'Nunito Sans', sans-serif;
    }



    .btn-purple {
        background: rgb(35, 10, 118, 0.7);
        color: #FFFF;
    }

    .btn-purple:hover {
        background: rgb(35, 10, 118, 0.9);
        color: #FFFF;
    }

    label {
        letter-spacing: 0.05em;
    }

    .form-control:focus {

        box-shadow: 0 0 10px rgba(255, 153, 0, 0.5);
        color: #000000;



    }


    @media(max-width: 767px) {
        .poster {
            height: 100%;
            width: 100%;
            position: relative;

        }
    }

    @media(min-width: 767px) {
        .poster {
            height: 100vh;
            position: relative;
            width: 100%;

        }
    }

    .form-control::placeholder {
        letter-spacing: 0.05em;
        font-size: 16px;
        color: #000000;
        text-align: center;

    }

    .custom-input {
        background: inherit;
        text-align: center;
        color: #000000;
    }

    /* Override autofill background color */
    .custom-input:not(:placeholder-shown) {
        background-color: inherit !important;
    }



    .login-head {
        letter-spacing: 0.05em;
        text-align: center;
        margin-bottom: 36px;
        font-size: 16px;

    }


    @media only screen and (min-width:1367px) and (max-width:1920px) {
        .loginsection {
            margin-top: 3px !important;
            margin-botttom: 3px !important;
        }

        .logo {
            width: 105px;
            height: 105px;
            border-radius: 9%;
        }

        .mobile-mb-0 {
            margin-bottom: 0 !important;
        }

        .login-head {
            font-size: 22px;
        }
    }


    .icon-placeholder {
        position: absolute;
        bottom: 10px;
        left: 15px;
    }

    @media(max-width:412px) {
        .icon-placeholder {
            bottom: 10px;
            left: 8px;

        }
    }

    input:-webkit-autofill,
    input:-webkit-autofill:hover,
    input:-webkit-autofill:focus,
    input:-webkit-autofill:active {
        -webkit-box-shadow: 0 0 0 30px #f0f2f7 inset !important;
        -webkit-text-fill-color: #000000 !important;
    }


    @media only screen and (min-width:1200px) and (max-width:1366px) {


        .logo {
            width: 80px;
            height: auto;
        }
    }

    @media only screen and (min-width:1367px) and (max-width:1920px) {


        .logo {
            width: 105px;
            height: 105px;
        }

    }
</style>
