import { useEffect } from "react";
import { useDispatch } from "react-redux";
import { fetchClusters } from "../../store/asyncMethods/clusterMethod";
import Clusters from "./Nodes/Clusters/Clusters";
import { fetchCables } from "../../store/asyncMethods/cableMethod";
import Cables from "./Nodes/Cables/Cables";
import { fetchTjBoxData } from "../../store/asyncMethods/tjBoxMethod";
import TjBoxes from "./Nodes/TjBBoxes/TJBoxes";
import { fetchBoxClients } from "../../store/asyncMethods/boxClientMethod";
import ClusterView from "./Nodes/Clusters/ClusterView/ClusterView";
import ShowNonBoxClients from "./Nodes/ShowNonBoxClients/ShowNonBoxClients";
import { fetchPopsMethod } from "../../store/asyncMethods/popMethod";
import { Pops } from "./Nodes/Pops/Pops";

const PrintAllNode = () => {
    const dispatch = useDispatch();
    useEffect(() => {
        dispatch(fetchClusters());
        dispatch(fetchCables());
        dispatch(fetchTjBoxData());
        dispatch(fetchBoxClients());
        dispatch(fetchPopsMethod());
    }, [dispatch]);
    return (
        <>
            <Clusters />
            <Cables />
            <TjBoxes />
            <ClusterView />
            <ShowNonBoxClients />
            <Pops />
        </>
    );
};

export default PrintAllNode;
