import { useSelector } from "react-redux";
import { Marker, Circle, OverlayView } from "@react-google-maps/api";
import { createCoordinateObject } from "../../../../util/validate";
import clientIcon from "../../../../assets/icons/pop.png";

const options = {
    strokeColor: "#0D6EFD", // circle border
    strokeOpacity: 0.8,
    strokeWeight: 2,
    fillColor: "#6CCFF6", // fill color
    fillOpacity: 0.2,
    clickable: false,
    draggable: false,
    editable: false,
    visible: true,
    radius: 1500, // 1.5 km in meters
    zIndex: 1,
};

const Pop = ({ popData }) => {
    const coordinates = createCoordinateObject(
        popData.latitude,
        popData.longitude
    );
    return (
        <>
            {" "}
            <Marker position={coordinates} icon={clientIcon} />
            <OverlayView
                position={coordinates}
                mapPaneName={OverlayView.OVERLAY_MOUSE_TARGET}
                getPixelPositionOffset={() => ({
                    x: -23,
                    y: -67,
                })}
            >
                <div
                    className="p-2 text-white bg-dark rounded d-flex align-items-center"
                    style={{ position: "absolute", whiteSpace: "nowrap" }}
                >
                    {popData.popname}
                </div>
            </OverlayView>
            {/* Circle with 3 km radius */}
            <Circle center={coordinates} options={options} />
        </>
    );
};

export const Pops = () => {
    const { pops } = useSelector(({ popReducer }) => popReducer);

    return (
        <>
            {pops?.map((pop) => (
                <Pop popData={pop} key={pop.id} />
            ))}
        </>
    );
};
