import { Badge, Col, Container } from "react-bootstrap";
import _ from "lodash";
import { getColor, getFiberInfo } from "../../../../../../util/colorModule";
import { MdCable } from "react-icons/md";
import { ConnectedComponent } from "./ConnectedComponent";
import { VscDebugDisconnect } from "react-icons/vsc";

export const SplitterOutputFiber = ({
    outputCore,
    onDisconnectSplitterOutput,
}) => {
    const fiberInfo = getFiberInfo(outputCore.out_number);

    return (
        <Col xl={6} xxl={4} lg={6} sm={12}>
            <Container fluid className="d-flex shadow-sm rounded pt-1 py-2">
                <h5 className="bg-dark text-light rounded me-1 p-2 d-flex align-items-center">
                    {outputCore.out_number}:{_.toUpper(fiberInfo?.color)}{" "}
                    <div
                        className="ms-1 p-1 rounded border-white border-2"
                        style={{ backgroundColor: fiberInfo?.hex }}
                    ></div>
                </h5>{" "}
                <div>
                    {outputCore.fiber ? (
                        <Badge className="ms-1" bg="dark">
                            <MdCable /> {outputCore.fiber.cable.name}: (
                            {outputCore.fiber.fiber_number}:
                            {_.toUpper(getColor(outputCore.fiber.fiber_number))}
                            )
                        </Badge>
                    ) : (
                        <ConnectedComponent
                            connected_component={outputCore.connected_component}
                        />
                    )}

                    {(outputCore.fiber || outputCore.connected_component) && (
                        <Badge
                            pill
                            className="ms-1"
                            bg="danger"
                            role="button"
                            onClick={() =>
                                onDisconnectSplitterOutput(outputCore.id)
                            }
                        >
                            <VscDebugDisconnect />
                        </Badge>
                    )}
                </div>
            </Container>
        </Col>
    );
};
