import { Badge } from "react-bootstrap";
import { MdImportExport } from "react-icons/md";
import _ from "lodash";

export const ConnectedComponent = ({ connected_component, cluster }) => {
    switch (connected_component?.type) {
        case "port":
            return (
                <Badge
                    pill
                    className="m-0"
                    bg={
                        cluster.id !== connected_component.device.cluster_id
                            ? "primary"
                            : "dark"
                    }
                >
                    <MdImportExport />
                    <span className="fw-bold">
                        {_.capitalize(connected_component.device.type)}
                    </span>
                    :- {connected_component.device.name}:
                    {connected_component.port_number}
                </Badge>
            );

        case "splitter":
            return (
                <Badge
                    pill
                    className="m-0"
                    bg={
                        cluster.id !== connected_component.cluster_id
                            ? "primary"
                            : "dark"
                    }
                >
                    <MdImportExport />{" "}
                    <span className="fw-bold">
                        {_.capitalize(connected_component.type)}
                    </span>
                    :- {connected_component.name} 1:
                    {connected_component.split_ratio}
                </Badge>
            );
        case "onu":
            return (
                <Badge pill className="m-0" bg={"dark"}>
                    <span>{_.capitalize(connected_component.type)}</span>:-{" "}
                    {connected_component.id}:{connected_component.name} (
                    {connected_component.manufactures}:
                    {connected_component.mac_address})
                </Badge>
            );

        case "client":
            return (
                <Badge pill className="m-0" bg={"dark"}>
                    <span>{_.capitalize(connected_component?.type)}</span>:-{" "}
                    {connected_component?.client?.id}.{" "}
                    {connected_component?.clients_name} (
                    {connected_component?.client?.userid}:{" "}
                    {connected_component?.client?.clients_status} ){" "}
                    {connected_component?.client?.userid ? "" : " deleted"}
                </Badge>
            );
        default:
            return (
                <Badge pill className="m-0" bg={"dark"}>
                    No device connected
                </Badge>
            );
    }
};
