import { Modal, Tab, Tabs } from "react-bootstrap";
import ClusterInfo from "./ClusterInfo";
import ClusterDevices from "./ClusterDevices";
import ConnectDevices from "./ConnectDevices/ConnectDevices";
import ClusterAddComponents from "./AddComponent";
import ClientsDetail from "./ClientsDetail/ClientsDetail";
import { useDispatch, useSelector } from "react-redux";
import {
    removeCurrentCluster,
    setOpenClusterView,
    setViewKey,
} from "../../../../../store/reducers/currentClusterReducer";
import { TjConnect } from "../../TjBBoxes/TjBoxConnect/TjConnect";

const ClusterView = () => {
    const {
        currentCluster: clusterInfo,
        openClusterView,
        viewKey,
    } = useSelector(({ currentClusterReducer }) => currentClusterReducer);
    const dispatch = useDispatch();

    const onCloseHandler = () => {
        dispatch(setOpenClusterView(false));
        dispatch(removeCurrentCluster());
    };

    return (
        clusterInfo && (
            <Modal
                show={openClusterView}
                onHide={onCloseHandler}
                fullscreen={true}
            >
                <Modal.Header closeButton>
                    <Modal.Title>
                        {clusterInfo.name} -{" "}
                        {clusterInfo.isBox
                            ? "Client Distribution Box"
                            : "Cluster/Organization"}
                    </Modal.Title>
                </Modal.Header>
                <Modal.Body>
                    <ClusterInfo />
                    <Tabs
                        activeKey={viewKey}
                        className="mb-3"
                        onSelect={(key) => dispatch(setViewKey(key))}
                    >
                        <Tab eventKey="view" title="View Devices">
                            <ClusterDevices cluster={clusterInfo} />
                        </Tab>
                        <Tab eventKey="add" title="Add New Component">
                            <ClusterAddComponents />
                        </Tab>
                        <Tab eventKey="connect" title="Connect Device">
                            <ConnectDevices cluster={clusterInfo} />
                        </Tab>
                        <Tab
                            eventKey="OpticalTerminal"
                            title="Optical Terminal"
                        >
                            {" "}
                            <TjConnect tjBoxInfo={clusterInfo} />
                        </Tab>
                        <Tab eventKey="clients" title="Clients">
                            {" "}
                            <ClientsDetail clients={clusterInfo.clients} />
                        </Tab>
                    </Tabs>
                </Modal.Body>
            </Modal>
        )
    );
};

export default ClusterView;
