import { useState } from 'react';
import { Badge, Card, Col, Row, Tab, Tabs } from 'react-bootstrap';
import './ClusterDevices.css';
import DeviceDetailView from './DeviceDetail/DeviceDetail';
import { MdOutlineLan } from 'react-icons/md';
import SplitterDetail from './SplitterDetail/SplitterDetail';
import { BsHddNetwork } from 'react-icons/bs';
import OnuDetail from './OnuDetail/OnuDetail';

const DeviceListItem = ({ device: component, setSelectedDevice }) => {
    if (component.type === 'splitter') {
        return (
            <Card
                className='mb-2 me-1 mt-1'
                role='button'
                onClick={() => setSelectedDevice(component)}
            >
                <Card.Body className='p-2'>
                    <h6 className='m-0 mb-1 fw-bold'>
                        {component.id}:{component.name}
                    </h6>
                    <p className='m-0 text-muted'>
                        {' '}
                        <Badge pill bg='success' className='me-1'>
                            Used {component.used}{' '}
                        </Badge>
                        | <MdOutlineLan /> 1/{component.split_ratio}
                    </p>
                </Card.Body>
            </Card>
        );
    } else if (component.type === 'onu') {
        return (
            <Card
                className='mb-2 me-1 mt-1'
                role='button'
                onClick={() => setSelectedDevice(component)}
            >
                <Card.Body className='p-2'>
                    <h6 className='m-0 mb-1 fw-bold'>
                        {component.id}: <BsHddNetwork /> {component.name}
                    </h6>
                    <p className='m-0 text-muted'>
                        {' '}
                        {component.manufactures}{' '}
                        {component.model && '| ' + component.model}{' '}
                        {component.mac_address && '| ' + component.mac_address}
                    </p>
                </Card.Body>
            </Card>
        );
    }

    return (
        <Card
            className='mb-2 me-1 mt-1'
            role='button'
            onClick={() => setSelectedDevice(component)}
        >
            <Card.Body className='p-2'>
                <h6 className='m-0 mb-1 fw-bold'>
                    {component.id}:{component.name}
                </h6>
                <p className='m-0 text-muted'>
                    {' '}
                    <Badge pill bg='success'>
                        {component.manufactures}
                    </Badge>{' '}
                    | {component.model}
                </p>
            </Card.Body>
        </Card>
    );
};

function DetailComponent(props) {
    switch (props?.selectedDevice?.type) {
        case 'device':
            return (
                <DeviceDetailView
                    selectedDevice={props.selectedDevice}
                    cluster={props.cluster}
                />
            );
        case 'splitter':
            return (
                <SplitterDetail
                    selectedSplitter={props.selectedDevice}
                    cluster={props.cluster}
                />
            );
        case 'onu':
            return (
                <OnuDetail
                    selectedDevice={props.selectedDevice}
                    cluster={props.cluster}
                />
            );
        default:
            return (
                <h4 className='text-center text-muted'>
                    Please select a device from the list to view its details
                </h4>
            );
    }
}

const ClusterDevices = ({ cluster }) => {
    const [selectedDevice, setSelectedDevice] = useState(null);

    return (
        <Row>
            <Col lg={2} className='device_list'>
                <h6 className='text-center'>Devices & Splitters</h6>
                <hr className='m-0' />
                <Tabs>
                    <Tab eventKey='devices' title='Devices'>
                        {cluster.devices.map((device) => {
                            return (
                                <DeviceListItem
                                    device={device}
                                    key={device.id}
                                    setSelectedDevice={setSelectedDevice}
                                />
                            );
                        })}
                    </Tab>
                    <Tab eventKey='splitters' title='Splitters'>
                        {cluster.splitters.map((device) => {
                            return (
                                <DeviceListItem
                                    device={device}
                                    key={device.id}
                                    setSelectedDevice={setSelectedDevice}
                                />
                            );
                        })}
                    </Tab>
                    <Tab eventKey='Onu' title='ONU'>
                        {cluster.onus.map((device) => {
                            return (
                                <DeviceListItem
                                    device={device}
                                    key={device.id}
                                    setSelectedDevice={setSelectedDevice}
                                />
                            );
                        })}
                    </Tab>
                </Tabs>
            </Col>
            <Col lg={10}>
                <DetailComponent
                    selectedDevice={selectedDevice}
                    cluster={cluster}
                />
            </Col>
        </Row>
    );
};

export default ClusterDevices;
