<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddRemoteAccessToClientsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('clients', function (Blueprint $table) {
            $table->enum('remote_access', ['Yes', 'No'])->default('No');
            $table->string('remote_access_username')->nullable();
            $table->string('remote_access_password')->nullable();
            $table->string('remote_access_port')->nullable();
            $table->foreignId('line_man_id')->nullable();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('clients', function (Blueprint $table) {
            $table->dropColumn('remote_access');
            $table->dropColumn('remote_access_username');
            $table->dropColumn('remote_access_password');
            $table->dropColumn('remote_access_port');
            $table->dropColumn('line_man_id');
        });
    }
}
