<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateNewLineRequestsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('new_line_requests', function (Blueprint $table) {
            $table->id();
            $table->string('name')->required();
            $table->string('father_name')->nullable();
            $table->string('mother_name')->nullable();
            $table->string('address')->required();
            $table->foreignId('pop_id')->constrained('pops')->required();
            $table->foreignId('package_id')->constrained('packages')->required();
            $table->integer('otc')->required();
            $table->integer('fiver_miter')->required();
            $table->string('phone')->required();
            $table->string('lat')->nullable();
            $table->string('long')->nullable();
            $table->integer('created_by')->required();
            $table->string('status')->default('pending');
            $table->longText('remarks')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('new_line_requests');
    }
}
