<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreatePgwResponseLogsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('pgw_response_logs', function (Blueprint $table) {
            $table->id();
            $table->text('response');
            $table->enum('status',['Success','Failed'])->nullable();
            $table->string('payment_ref_id')->nullable();
            $table->text('error_massage')->nullable();
            $table->enum('payment_for',['Pop','Reseller','Client'])->nullable();
            $table->enum('payment_method',['Bkash','Nagad','Upay','Sslcommerz'])->nullable();
            $table->foreignId('user_id')->nullable();
            $table->enum('source',['Payment_initiate','Call_back_url'])->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('pgw_response_logs');
    }
}
